/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.data.input.impl.SpatialDimensionSchema;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.DimensionSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.TimestampColumnSelector;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.SpatialDimensionRowFormatter;
import io.druid.segment.serde.ComplexMetricExtractor;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class IncrementalIndex
implements Iterable<Row> {
    private static final Logger log = new Logger(IncrementalIndex.class);
    private static final Joiner JOINER = Joiner.on((String)",");
    private final long minTimestamp;
    private final QueryGranularity gran;
    private final AggregatorFactory[] metrics;
    private final Map<String, Integer> metricIndexes;
    private final Map<String, String> metricTypes;
    private final ImmutableList<String> metricNames;
    private final LinkedHashMap<String, Integer> dimensionOrder;
    private final CopyOnWriteArrayList<String> dimensions;
    private final List<SpatialDimensionSchema> spatialDimensions;
    private final SpatialDimensionRowFormatter spatialDimensionRowFormatter;
    private final DimensionHolder dimValues;
    private final ConcurrentSkipListMap<TimeAndDims, Aggregator[]> facts;
    private volatile int numEntries = 0;
    private InputRow in;

    public IncrementalIndex(IncrementalIndexSchema incrementalIndexSchema) {
        this.minTimestamp = incrementalIndexSchema.getMinTimestamp();
        this.gran = incrementalIndexSchema.getGran();
        this.metrics = incrementalIndexSchema.getMetrics();
        ImmutableList.Builder metricNamesBuilder = ImmutableList.builder();
        ImmutableMap.Builder metricIndexesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder metricTypesBuilder = ImmutableMap.builder();
        for (int i = 0; i < this.metrics.length; ++i) {
            String metricName = this.metrics[i].getName().toLowerCase();
            metricNamesBuilder.add((Object)metricName);
            metricIndexesBuilder.put((Object)metricName, (Object)i);
            metricTypesBuilder.put((Object)metricName, (Object)this.metrics[i].getTypeName());
        }
        this.metricNames = metricNamesBuilder.build();
        this.metricIndexes = metricIndexesBuilder.build();
        this.metricTypes = metricTypesBuilder.build();
        this.dimensionOrder = Maps.newLinkedHashMap();
        this.dimensions = new CopyOnWriteArrayList();
        int index = 0;
        for (String dim : incrementalIndexSchema.getDimensions()) {
            this.dimensionOrder.put(dim, index++);
            this.dimensions.add(dim);
        }
        this.spatialDimensions = incrementalIndexSchema.getSpatialDimensions();
        this.spatialDimensionRowFormatter = new SpatialDimensionRowFormatter(this.spatialDimensions);
        this.dimValues = new DimensionHolder();
        this.facts = new ConcurrentSkipListMap();
    }

    public IncrementalIndex(long minTimestamp, QueryGranularity gran, AggregatorFactory[] metrics) {
        this(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).build());
    }

    public int add(InputRow row) {
        if ((row = this.spatialDimensionRowFormatter.formatRow(row)).getTimestampFromEpoch() < this.minTimestamp) {
            throw new IAE("Cannot add row[%s] because it is below the minTimestamp[%s]", new Object[]{row, new DateTime(this.minTimestamp)});
        }
        List rowDimensions = row.getDimensions();
        String[][] dims = new String[this.dimensionOrder.size()][];
        List overflow = null;
        for (String dimension : rowDimensions) {
            dimension = dimension.toLowerCase();
            List dimensionValues = row.getDimension(dimension);
            Integer index = this.dimensionOrder.get(dimension);
            if (index == null) {
                this.dimensionOrder.put(dimension, this.dimensionOrder.size());
                this.dimensions.add(dimension);
                if (overflow == null) {
                    overflow = Lists.newArrayList();
                }
                overflow.add(this.getDimVals(this.dimValues.add(dimension), dimensionValues));
                continue;
            }
            dims[index.intValue()] = this.getDimVals(this.dimValues.get(dimension), dimensionValues);
        }
        if (overflow != null) {
            String[][] newDims = new String[dims.length + overflow.size()][];
            System.arraycopy(dims, 0, newDims, 0, dims.length);
            for (int i = 0; i < overflow.size(); ++i) {
                newDims[dims.length + i] = (String[])overflow.get(i);
            }
            dims = newDims;
        }
        TimeAndDims key = new TimeAndDims(Math.max(this.gran.truncate(row.getTimestampFromEpoch()), this.minTimestamp), dims);
        this.in = row;
        Aggregator[] aggs = this.facts.get(key);
        if (aggs == null) {
            aggs = new Aggregator[this.metrics.length];
            for (int i = 0; i < this.metrics.length; ++i) {
                final AggregatorFactory agg = this.metrics[i];
                aggs[i] = agg.factorize(new ColumnSelectorFactory(){

                    @Override
                    public TimestampColumnSelector makeTimestampColumnSelector() {
                        return new TimestampColumnSelector(){

                            @Override
                            public long getTimestamp() {
                                return IncrementalIndex.this.in.getTimestampFromEpoch();
                            }
                        };
                    }

                    @Override
                    public FloatColumnSelector makeFloatColumnSelector(String columnName) {
                        final String metricName = columnName.toLowerCase();
                        return new FloatColumnSelector(){

                            @Override
                            public float get() {
                                return IncrementalIndex.this.in.getFloatMetric(metricName);
                            }
                        };
                    }

                    @Override
                    public ObjectColumnSelector makeObjectColumnSelector(String column) {
                        String typeName = agg.getTypeName();
                        final String columnName = column.toLowerCase();
                        if (typeName.equals("float")) {
                            return new ObjectColumnSelector<Float>(){

                                @Override
                                public Class classOfObject() {
                                    return Float.TYPE;
                                }

                                @Override
                                public Float get() {
                                    return Float.valueOf(IncrementalIndex.this.in.getFloatMetric(columnName));
                                }
                            };
                        }
                        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
                        if (serde == null) {
                            throw new ISE("Don't know how to handle type[%s]", new Object[]{typeName});
                        }
                        final ComplexMetricExtractor extractor = serde.getExtractor();
                        return new ObjectColumnSelector(){

                            public Class classOfObject() {
                                return extractor.extractedClass();
                            }

                            public Object get() {
                                return extractor.extractValue(IncrementalIndex.this.in, columnName);
                            }
                        };
                    }

                    @Override
                    public DimensionSelector makeDimensionSelector(String dimension) {
                        throw new UnsupportedOperationException("Incremental index aggregation does not support dimension selectors");
                    }
                });
            }
            this.facts.put(key, aggs);
            ++this.numEntries;
        }
        for (Aggregator agg : aggs) {
            agg.aggregate();
        }
        this.in = null;
        return this.numEntries;
    }

    public boolean isEmpty() {
        return this.numEntries == 0;
    }

    public int size() {
        return this.numEntries;
    }

    public long getMinTimeMillis() {
        return this.facts.firstKey().getTimestamp();
    }

    public long getMaxTimeMillis() {
        return this.facts.lastKey().getTimestamp();
    }

    private String[] getDimVals(DimDim dimLookup, List<String> dimValues) {
        Object[] retVal = new String[dimValues.size()];
        int count = 0;
        for (String dimValue : dimValues) {
            String canonicalDimValue = dimLookup.get(dimValue);
            if (canonicalDimValue == null) {
                canonicalDimValue = dimValue;
                dimLookup.add(dimValue);
            }
            retVal[count] = canonicalDimValue;
            ++count;
        }
        Arrays.sort(retVal);
        return retVal;
    }

    public AggregatorFactory[] getMetricAggs() {
        return this.metrics;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public List<SpatialDimensionSchema> getSpatialDimensions() {
        return this.spatialDimensions;
    }

    public SpatialDimensionRowFormatter getSpatialDimensionRowFormatter() {
        return this.spatialDimensionRowFormatter;
    }

    public String getMetricType(String metric) {
        return this.metricTypes.get(metric);
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public QueryGranularity getGranularity() {
        return this.gran;
    }

    public Interval getInterval() {
        return new Interval(this.minTimestamp, this.isEmpty() ? this.minTimestamp : this.gran.next(this.getMaxTimeMillis()));
    }

    public DateTime getMinTime() {
        return this.isEmpty() ? null : new DateTime(this.getMinTimeMillis());
    }

    public DateTime getMaxTime() {
        return this.isEmpty() ? null : new DateTime(this.getMaxTimeMillis());
    }

    DimDim getDimension(String dimension) {
        return this.isEmpty() ? null : this.dimValues.get(dimension);
    }

    Integer getDimensionIndex(String dimension) {
        return this.dimensionOrder.get(dimension);
    }

    List<String> getMetricNames() {
        return this.metricNames;
    }

    Integer getMetricIndex(String metricName) {
        return this.metricIndexes.get(metricName);
    }

    ConcurrentSkipListMap<TimeAndDims, Aggregator[]> getFacts() {
        return this.facts;
    }

    ConcurrentNavigableMap<TimeAndDims, Aggregator[]> getSubMap(TimeAndDims start, TimeAndDims end) {
        return this.facts.subMap((Object)start, (Object)end);
    }

    @Override
    public Iterator<Row> iterator() {
        return this.iterableWithPostAggregations(null).iterator();
    }

    public Iterable<Row> iterableWithPostAggregations(final List<PostAggregator> postAggs) {
        return new Iterable<Row>(){

            @Override
            public Iterator<Row> iterator() {
                return Iterators.transform(IncrementalIndex.this.facts.entrySet().iterator(), (Function)new Function<Map.Entry<TimeAndDims, Aggregator[]>, Row>(){

                    public Row apply(Map.Entry<TimeAndDims, Aggregator[]> input) {
                        int i;
                        TimeAndDims timeAndDims = input.getKey();
                        Aggregator[] aggregators = input.getValue();
                        String[][] theDims = timeAndDims.getDims();
                        LinkedHashMap theVals = Maps.newLinkedHashMap();
                        for (i = 0; i < theDims.length; ++i) {
                            String[] dim = theDims[i];
                            if (dim == null || dim.length == 0) continue;
                            theVals.put(IncrementalIndex.this.dimensions.get(i), dim.length == 1 ? dim[0] : Arrays.asList(dim));
                        }
                        for (i = 0; i < aggregators.length; ++i) {
                            theVals.put(IncrementalIndex.this.metrics[i].getName(), aggregators[i].get());
                        }
                        if (postAggs != null) {
                            for (PostAggregator postAgg : postAggs) {
                                theVals.put(postAgg.getName(), postAgg.compute(theVals));
                            }
                        }
                        return new MapBasedRow(timeAndDims.getTimestamp(), (Map)theVals);
                    }
                });
            }
        };
    }

    static class DimDim {
        private final Map<String, String> poorMansInterning = Maps.newConcurrentMap();
        private final Map<String, Integer> falseIds;
        private final Map<Integer, String> falseIdsReverse;
        private volatile String[] sortedVals = null;

        public DimDim() {
            BiMap biMap;
            this.falseIds = biMap = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
            this.falseIdsReverse = biMap.inverse();
        }

        public String get(String value) {
            return value == null ? null : this.poorMansInterning.get(value);
        }

        public int getId(String value) {
            return this.falseIds.get(value);
        }

        public String getValue(int id) {
            return this.falseIdsReverse.get(id);
        }

        public int size() {
            return this.poorMansInterning.size();
        }

        public Set<String> keySet() {
            return this.poorMansInterning.keySet();
        }

        public synchronized void add(String value) {
            this.poorMansInterning.put(value, value);
            this.falseIds.put(value, this.falseIds.size());
        }

        public int getSortedId(String value) {
            this.assertSorted();
            return Arrays.binarySearch(this.sortedVals, value);
        }

        public String getSortedValue(int index) {
            this.assertSorted();
            return this.sortedVals[index];
        }

        public void sort() {
            if (this.sortedVals == null) {
                this.sortedVals = new String[this.falseIds.size()];
                int index = 0;
                for (String value : this.falseIds.keySet()) {
                    this.sortedVals[index++] = value;
                }
                Arrays.sort(this.sortedVals);
            }
        }

        private void assertSorted() {
            if (this.sortedVals == null) {
                throw new ISE("Call sort() before calling the getSorted* methods.", new Object[0]);
            }
        }
    }

    static class TimeAndDims
    implements Comparable<TimeAndDims> {
        private final long timestamp;
        private final String[][] dims;

        TimeAndDims(long timestamp, String[][] dims) {
            this.timestamp = timestamp;
            this.dims = dims;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        String[][] getDims() {
            return this.dims;
        }

        @Override
        public int compareTo(TimeAndDims rhs) {
            int retVal = Longs.compare((long)this.timestamp, (long)rhs.timestamp);
            if (retVal == 0) {
                retVal = Ints.compare((int)this.dims.length, (int)rhs.dims.length);
            }
            int index = 0;
            while (retVal == 0 && index < this.dims.length) {
                String[] lhsVals = this.dims[index];
                String[] rhsVals = rhs.dims[index];
                if (lhsVals == null) {
                    if (rhsVals == null) {
                        ++index;
                        continue;
                    }
                    return -1;
                }
                if (rhsVals == null) {
                    return 1;
                }
                retVal = Ints.compare((int)lhsVals.length, (int)rhsVals.length);
                for (int valsIndex = 0; retVal == 0 && valsIndex < lhsVals.length; ++valsIndex) {
                    retVal = lhsVals[valsIndex].compareTo(rhsVals[valsIndex]);
                }
                ++index;
            }
            return retVal;
        }

        public String toString() {
            return "TimeAndDims{timestamp=" + new DateTime(this.timestamp) + ", dims=" + Lists.transform(Arrays.asList(this.dims), (Function)new Function<String[], Object>(){

                public Object apply(@Nullable String[] input) {
                    if (input == null || input.length == 0) {
                        return Arrays.asList("null");
                    }
                    return Arrays.asList(input);
                }
            }) + '}';
        }
    }

    static class DimensionHolder {
        private final Map<String, DimDim> dimensions = Maps.newConcurrentMap();

        DimensionHolder() {
        }

        void reset() {
            this.dimensions.clear();
        }

        DimDim add(String dimension) {
            DimDim holder = this.dimensions.get(dimension);
            if (holder != null) {
                throw new ISE("dimension[%s] already existed even though add() was called!?", new Object[]{dimension});
            }
            holder = new DimDim();
            this.dimensions.put(dimension, holder);
            return holder;
        }

        DimDim get(String dimension) {
            return this.dimensions.get(dimension);
        }
    }
}

