/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.collect.Lists;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.util.ArrayList;
import java.util.List;

public class OrFilter
implements Filter {
    private final List<Filter> filters;

    public OrFilter(List<Filter> filters) {
        if (filters.size() == 0) {
            throw new IllegalArgumentException("Can't construct empty OrFilter (the universe does not exist)");
        }
        this.filters = filters;
    }

    @Override
    public ImmutableConciseSet goConcise(BitmapIndexSelector selector) {
        if (this.filters.size() == 1) {
            return this.filters.get(0).goConcise(selector);
        }
        ArrayList conciseSets = Lists.newArrayList();
        for (int i = 0; i < this.filters.size(); ++i) {
            conciseSets.add(this.filters.get(i).goConcise(selector));
        }
        return ImmutableConciseSet.union((Iterable)conciseSets);
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        final ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        for (int i = 0; i < this.filters.size(); ++i) {
            matchers[i] = this.filters.get(i).makeMatcher(factory);
        }
        if (matchers.length == 1) {
            return matchers[0];
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                for (ValueMatcher matcher : matchers) {
                    if (!matcher.matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

