/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.metamx.common.guava.FunctionalIterable;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import javax.annotation.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptFilter
implements Filter {
    private final JavaScriptPredicate predicate;
    private final String dimension;

    public JavaScriptFilter(String dimension, String script) {
        this.dimension = dimension;
        this.predicate = new JavaScriptPredicate(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableConciseSet goConcise(final BitmapIndexSelector selector) {
        final Context cx = Context.enter();
        try {
            ImmutableConciseSet conciseSet;
            ImmutableConciseSet immutableConciseSet = conciseSet = ImmutableConciseSet.union((Iterable)FunctionalIterable.create(selector.getDimensionValues(this.dimension)).filter((Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return JavaScriptFilter.this.predicate.applyInContext(cx, input);
                }
            }).transform((Function)new Function<String, ImmutableConciseSet>(){

                public ImmutableConciseSet apply(@Nullable String input) {
                    return selector.getConciseInvertedIndex(JavaScriptFilter.this.dimension, input);
                }
            }));
            return immutableConciseSet;
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, this.predicate);
    }

    static class JavaScriptPredicate
    implements Predicate<String> {
        final ScriptableObject scope;
        final org.mozilla.javascript.Function fnApply;
        final String script;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JavaScriptPredicate(String script) {
            Preconditions.checkNotNull((Object)script, (Object)"script must not be null");
            this.script = script;
            Context cx = Context.enter();
            try {
                cx.setOptimizationLevel(9);
                this.scope = cx.initStandardObjects();
                this.fnApply = cx.compileFunction((Scriptable)this.scope, script, "script", 1, null);
            }
            finally {
                Context.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(String input) {
            Context cx = Context.enter();
            try {
                boolean bl = this.applyInContext(cx, input);
                return bl;
            }
            finally {
                Context.exit();
            }
        }

        public boolean applyInContext(Context cx, String input) {
            return Context.toBoolean((Object)this.fnApply.call(cx, (Scriptable)this.scope, (Scriptable)this.scope, (Object[])new String[]{input}));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaScriptPredicate that = (JavaScriptPredicate)o;
            return this.script.equals(that.script);
        }

        public int hashCode() {
            return this.script.hashCode();
        }
    }
}

