/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.ExtractionDimFilter;
import io.druid.query.filter.Filter;
import io.druid.query.filter.JavaScriptDimFilter;
import io.druid.query.filter.NotDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.RegexDimFilter;
import io.druid.query.filter.SearchQueryDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.filter.SpatialDimFilter;
import io.druid.segment.filter.AndFilter;
import io.druid.segment.filter.ExtractionFilter;
import io.druid.segment.filter.JavaScriptFilter;
import io.druid.segment.filter.NotFilter;
import io.druid.segment.filter.OrFilter;
import io.druid.segment.filter.RegexFilter;
import io.druid.segment.filter.SearchQueryFilter;
import io.druid.segment.filter.SelectorFilter;
import io.druid.segment.filter.SpatialFilter;
import java.util.List;
import javax.annotation.Nullable;

public class Filters {
    public static List<Filter> convertDimensionFilters(List<DimFilter> filters) {
        return Lists.transform(filters, (Function)new Function<DimFilter, Filter>(){

            public Filter apply(@Nullable DimFilter input) {
                return Filters.convertDimensionFilters(input);
            }
        });
    }

    public static Filter convertDimensionFilters(DimFilter dimFilter) {
        if (dimFilter == null) {
            return null;
        }
        Filter filter = null;
        if (dimFilter instanceof AndDimFilter) {
            filter = new AndFilter(Filters.convertDimensionFilters(((AndDimFilter)dimFilter).getFields()));
        } else if (dimFilter instanceof OrDimFilter) {
            filter = new OrFilter(Filters.convertDimensionFilters(((OrDimFilter)dimFilter).getFields()));
        } else if (dimFilter instanceof NotDimFilter) {
            filter = new NotFilter(Filters.convertDimensionFilters(((NotDimFilter)dimFilter).getField()));
        } else if (dimFilter instanceof SelectorDimFilter) {
            SelectorDimFilter selectorDimFilter = (SelectorDimFilter)dimFilter;
            filter = new SelectorFilter(selectorDimFilter.getDimension(), selectorDimFilter.getValue());
        } else if (dimFilter instanceof ExtractionDimFilter) {
            ExtractionDimFilter extractionDimFilter = (ExtractionDimFilter)dimFilter;
            filter = new ExtractionFilter(extractionDimFilter.getDimension(), extractionDimFilter.getValue(), extractionDimFilter.getDimExtractionFn());
        } else if (dimFilter instanceof RegexDimFilter) {
            RegexDimFilter regexDimFilter = (RegexDimFilter)dimFilter;
            filter = new RegexFilter(regexDimFilter.getDimension(), regexDimFilter.getPattern());
        } else if (dimFilter instanceof SearchQueryDimFilter) {
            SearchQueryDimFilter searchQueryFilter = (SearchQueryDimFilter)dimFilter;
            filter = new SearchQueryFilter(searchQueryFilter.getDimension(), searchQueryFilter.getQuery());
        } else if (dimFilter instanceof JavaScriptDimFilter) {
            JavaScriptDimFilter javaScriptDimFilter = (JavaScriptDimFilter)dimFilter;
            filter = new JavaScriptFilter(javaScriptDimFilter.getDimension(), javaScriptDimFilter.getFunction());
        } else if (dimFilter instanceof SpatialDimFilter) {
            SpatialDimFilter spatialDimFilter = (SpatialDimFilter)dimFilter;
            filter = new SpatialFilter(spatialDimFilter.getDimension(), spatialDimFilter.getBound());
        }
        return filter;
    }
}

