/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Ordering;
import com.metamx.collections.spatial.ImmutableRTree;
import io.druid.segment.data.ObjectStrategy;
import java.nio.ByteBuffer;

public class IndexedRTree
implements Comparable<IndexedRTree> {
    public static ObjectStrategy<ImmutableRTree> objectStrategy = new ImmutableRTreeObjectStrategy();
    private static Ordering<ImmutableRTree> comparator = new Ordering<ImmutableRTree>(){

        public int compare(ImmutableRTree tree, ImmutableRTree tree1) {
            if (tree.size() == 0 && tree1.size() == 0) {
                return 0;
            }
            if (tree.size() == 0) {
                return -1;
            }
            if (tree1.size() == 0) {
                return 1;
            }
            return tree.compareTo(tree1);
        }
    }.nullsFirst();
    private final ImmutableRTree immutableRTree;

    public IndexedRTree(ImmutableRTree immutableRTree) {
        this.immutableRTree = immutableRTree;
    }

    @Override
    public int compareTo(IndexedRTree spatialIndexedInts) {
        return this.immutableRTree.compareTo(spatialIndexedInts.getImmutableRTree());
    }

    public ImmutableRTree getImmutableRTree() {
        return this.immutableRTree;
    }

    private static class ImmutableRTreeObjectStrategy
    implements ObjectStrategy<ImmutableRTree> {
        private ImmutableRTreeObjectStrategy() {
        }

        @Override
        public Class<? extends ImmutableRTree> getClazz() {
            return ImmutableRTree.class;
        }

        @Override
        public ImmutableRTree fromByteBuffer(ByteBuffer buffer, int numBytes) {
            buffer.limit(buffer.position() + numBytes);
            return new ImmutableRTree(buffer.asReadOnlyBuffer());
        }

        @Override
        public byte[] toBytes(ImmutableRTree val) {
            if (val == null || val.size() == 0) {
                return new byte[0];
            }
            return val.toBytes();
        }

        @Override
        public int compare(ImmutableRTree o1, ImmutableRTree o2) {
            return comparator.compare((Object)o1, (Object)o2);
        }
    }
}

