/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Charsets;
import com.google.common.collect.Ordering;
import com.google.common.io.Closeables;
import com.google.common.primitives.Ints;
import com.metamx.common.IAE;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.ObjectStrategy;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Iterator;

public class GenericIndexed<T>
implements Indexed<T> {
    private static final byte version = 1;
    private final ByteBuffer theBuffer;
    private final ObjectStrategy<T> strategy;
    private final boolean allowReverseLookup;
    private final int size;
    private final int valuesOffset;
    public static ObjectStrategy<String> stringStrategy = new ObjectStrategy<String>(){

        @Override
        public Class<? extends String> getClazz() {
            return String.class;
        }

        @Override
        public String fromByteBuffer(ByteBuffer buffer, int numBytes) {
            byte[] bytes = new byte[numBytes];
            buffer.get(bytes);
            return new String(bytes, Charsets.UTF_8);
        }

        @Override
        public byte[] toBytes(String val) {
            if (val == null) {
                return new byte[0];
            }
            return val.getBytes(Charsets.UTF_8);
        }

        @Override
        public int compare(String o1, String o2) {
            return Ordering.natural().nullsFirst().compare((Object)o1, (Object)o2);
        }
    };

    public static <T> GenericIndexed<T> fromArray(T[] objects, ObjectStrategy<T> strategy) {
        return GenericIndexed.fromIterable(Arrays.asList(objects), strategy);
    }

    public static <T> GenericIndexed<T> fromIterable(Iterable<T> objectsIterable, ObjectStrategy<T> strategy) {
        Iterator<T> objects = objectsIterable.iterator();
        if (!objects.hasNext()) {
            ByteBuffer buffer = ByteBuffer.allocate(4).putInt(0);
            buffer.flip();
            return new GenericIndexed<T>(buffer, strategy, true);
        }
        boolean allowReverseLookup = true;
        int count = 1;
        T prevVal = objects.next();
        while (objects.hasNext()) {
            T next = objects.next();
            if (strategy.compare(prevVal, next) >= 0) {
                allowReverseLookup = false;
            }
            if (prevVal instanceof Closeable) {
                Closeables.closeQuietly((Closeable)((Closeable)prevVal));
            }
            prevVal = next;
            ++count;
        }
        if (prevVal instanceof Closeable) {
            Closeables.closeQuietly((Closeable)((Closeable)prevVal));
        }
        ByteArrayOutputStream headerBytes = new ByteArrayOutputStream(4 + count * 4);
        ByteArrayOutputStream valueBytes = new ByteArrayOutputStream();
        int offset = 0;
        try {
            headerBytes.write(Ints.toByteArray((int)count));
            for (T object : objectsIterable) {
                byte[] bytes = strategy.toBytes(object);
                headerBytes.write(Ints.toByteArray((int)(offset += 4 + bytes.length)));
                valueBytes.write(Ints.toByteArray((int)bytes.length));
                valueBytes.write(bytes);
                if (!(object instanceof Closeable)) continue;
                Closeables.closeQuietly((Closeable)((Closeable)object));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ByteBuffer theBuffer = ByteBuffer.allocate(headerBytes.size() + valueBytes.size());
        theBuffer.put(headerBytes.toByteArray());
        theBuffer.put(valueBytes.toByteArray());
        theBuffer.flip();
        return new GenericIndexed<T>(theBuffer.asReadOnlyBuffer(), strategy, allowReverseLookup);
    }

    GenericIndexed(ByteBuffer buffer, ObjectStrategy<T> strategy, boolean allowReverseLookup) {
        this.theBuffer = buffer;
        this.strategy = strategy;
        this.allowReverseLookup = allowReverseLookup;
        this.size = this.theBuffer.getInt();
        this.valuesOffset = this.theBuffer.position() + (this.size << 2);
    }

    @Override
    public Class<? extends T> getClazz() {
        return this.strategy.getClazz();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T get(int index) {
        int endOffset;
        if (index < 0) {
            throw new IAE("Index[%s] < 0", new Object[]{index});
        }
        if (index >= this.size) {
            throw new IAE(String.format("Index[%s] >= size[%s]", index, this.size), new Object[0]);
        }
        ByteBuffer myBuffer = this.theBuffer.asReadOnlyBuffer();
        int startOffset = 4;
        if (index == 0) {
            endOffset = myBuffer.getInt();
        } else {
            myBuffer.position(myBuffer.position() + (index - 1) * 4);
            startOffset = myBuffer.getInt() + 4;
            endOffset = myBuffer.getInt();
        }
        if (startOffset == endOffset) {
            return null;
        }
        myBuffer.position(this.valuesOffset + startOffset);
        return this.strategy.fromByteBuffer(myBuffer, endOffset - startOffset);
    }

    @Override
    public int indexOf(T value) {
        if (!this.allowReverseLookup) {
            throw new UnsupportedOperationException("Reverse lookup not allowed.");
        }
        value = value != null && value.equals("") ? null : value;
        int minIndex = 0;
        int maxIndex = this.size - 1;
        while (minIndex <= maxIndex) {
            int currIndex = minIndex + maxIndex >>> 1;
            T currValue = this.get(currIndex);
            int comparison = this.strategy.compare(currValue, value);
            if (comparison == 0) {
                return currIndex;
            }
            if (comparison < 0) {
                minIndex = currIndex + 1;
                continue;
            }
            maxIndex = currIndex - 1;
        }
        return -(minIndex + 1);
    }

    public long getSerializedSize() {
        return this.theBuffer.remaining() + 2 + 4 + 4;
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{1, this.allowReverseLookup ? (byte)1 : 0}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)(this.theBuffer.remaining() + 4))));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.size)));
        channel.write(this.theBuffer.asReadOnlyBuffer());
    }

    public static <T> GenericIndexed<T> read(ByteBuffer buffer, ObjectStrategy<T> strategy) {
        byte versionFromBuffer = buffer.get();
        if (1 == versionFromBuffer) {
            boolean allowReverseLookup = buffer.get() == 1;
            int size = buffer.getInt();
            ByteBuffer bufferToUse = buffer.asReadOnlyBuffer();
            bufferToUse.limit(bufferToUse.position() + size);
            buffer.position(bufferToUse.limit());
            return new GenericIndexed<T>(bufferToUse, strategy, allowReverseLookup);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }

    @Override
    public Iterator<T> iterator() {
        return IndexedIterable.create(this).iterator();
    }
}

