/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Ordering;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.ObjectStrategy;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import java.nio.ByteBuffer;
import java.util.Iterator;
import javax.annotation.Nullable;

public class ConciseCompressedIndexedInts
implements IndexedInts,
Comparable<ConciseCompressedIndexedInts> {
    public static ObjectStrategy<ImmutableConciseSet> objectStrategy = new ImmutableConciseSetObjectStrategy();
    private static Ordering<ImmutableConciseSet> comparator = new Ordering<ImmutableConciseSet>(){

        public int compare(@Nullable ImmutableConciseSet conciseSet, @Nullable ImmutableConciseSet conciseSet1) {
            if (conciseSet.size() == 0 && conciseSet1.size() == 0) {
                return 0;
            }
            if (conciseSet.size() == 0) {
                return -1;
            }
            if (conciseSet1.size() == 0) {
                return 1;
            }
            return conciseSet.compareTo(conciseSet1);
        }
    }.nullsFirst();
    private final ImmutableConciseSet immutableConciseSet;

    public ConciseCompressedIndexedInts(ImmutableConciseSet conciseSet) {
        this.immutableConciseSet = conciseSet;
    }

    @Override
    public int compareTo(ConciseCompressedIndexedInts conciseCompressedIndexedInts) {
        return this.immutableConciseSet.compareTo(conciseCompressedIndexedInts.getImmutableConciseSet());
    }

    @Override
    public int size() {
        return this.immutableConciseSet.size();
    }

    @Override
    public int get(int index) {
        throw new UnsupportedOperationException("This is really slow, so it's just not supported.");
    }

    public ImmutableConciseSet getImmutableConciseSet() {
        return this.immutableConciseSet;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            IntSet.IntIterator baseIterator;
            {
                this.baseIterator = ConciseCompressedIndexedInts.this.immutableConciseSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseIterator.hasNext();
            }

            @Override
            public Integer next() {
                return this.baseIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class ImmutableConciseSetObjectStrategy
    implements ObjectStrategy<ImmutableConciseSet> {
        private ImmutableConciseSetObjectStrategy() {
        }

        @Override
        public Class<? extends ImmutableConciseSet> getClazz() {
            return ImmutableConciseSet.class;
        }

        @Override
        public ImmutableConciseSet fromByteBuffer(ByteBuffer buffer, int numBytes) {
            buffer.limit(buffer.position() + numBytes);
            return new ImmutableConciseSet(buffer.asReadOnlyBuffer());
        }

        @Override
        public byte[] toBytes(ImmutableConciseSet val) {
            if (val == null || val.size() == 0) {
                return new byte[0];
            }
            return val.toBytes();
        }

        @Override
        public int compare(ImmutableConciseSet o1, ImmutableConciseSet o2) {
            return comparator.compare((Object)o1, (Object)o2);
        }
    }
}

