/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.ning.compress.lzf.ChunkEncoder;
import com.ning.compress.lzf.LZFChunk;
import com.ning.compress.lzf.LZFDecoder;
import io.druid.collections.ResourceHolder;
import io.druid.segment.CompressedPools;
import io.druid.segment.data.ObjectStrategy;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CompressedObjectStrategy<T extends Buffer>
implements ObjectStrategy<ResourceHolder<T>> {
    private final ByteOrder order;
    private final BufferConverter<T> converter;

    protected CompressedObjectStrategy(ByteOrder order, BufferConverter<T> converter) {
        this.order = order;
        this.converter = converter;
    }

    @Override
    public Class<? extends ResourceHolder<T>> getClazz() {
        return ResourceHolder.class;
    }

    @Override
    public ResourceHolder<T> fromByteBuffer(ByteBuffer buffer, int numBytes) {
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        final ResourceHolder<ByteBuffer> bufHolder = CompressedPools.getByteBuf(this.order);
        final ByteBuffer buf = (ByteBuffer)bufHolder.get();
        buf.position(0);
        buf.limit(buf.capacity());
        try {
            ResourceHolder<byte[]> outputBytesHolder = CompressedPools.getOutputBytes();
            byte[] outputBytes = (byte[])outputBytesHolder.get();
            int numDecompressedBytes = LZFDecoder.decode((byte[])bytes, (byte[])outputBytes);
            buf.put(outputBytes, 0, numDecompressedBytes);
            buf.flip();
            Closeables.closeQuietly(outputBytesHolder);
            return new ResourceHolder<T>(){

                public T get() {
                    return (Buffer)CompressedObjectStrategy.this.converter.convert(buf);
                }

                public void close() throws IOException {
                    bufHolder.close();
                }
            };
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public byte[] toBytes(ResourceHolder<T> holder) {
        Buffer val = (Buffer)holder.get();
        ByteBuffer buf = ByteBuffer.allocate(this.converter.sizeOf(val.remaining())).order(this.order);
        this.converter.combine(buf, val);
        ResourceHolder<ChunkEncoder> encoder = CompressedPools.getChunkEncoder();
        LZFChunk chunk = ((ChunkEncoder)encoder.get()).encodeChunk(buf.array(), 0, buf.array().length);
        Closeables.closeQuietly(encoder);
        return chunk.getData();
    }

    @Override
    public int compare(ResourceHolder<T> o1, ResourceHolder<T> o2) {
        return this.converter.compare(o1.get(), o2.get());
    }

    public static interface BufferConverter<T> {
        public T convert(ByteBuffer var1);

        public int compare(T var1, T var2);

        public int sizeOf(int var1);

        public T combine(ByteBuffer var1, T var2);
    }
}

