/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.OutputSupplier;
import com.google.common.primitives.Ints;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.data.CompressedLongBufferObjectStrategy;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

public class CompressedLongsSupplierSerializer {
    private final int sizePer;
    private final GenericIndexedWriter<ResourceHolder<LongBuffer>> flattener;
    private int numInserted = 0;
    private LongBuffer endBuffer;

    public static CompressedLongsSupplierSerializer create(IOPeon ioPeon, String filenameBase, ByteOrder order) throws IOException {
        CompressedLongsSupplierSerializer retVal = new CompressedLongsSupplierSerializer(8191, new GenericIndexedWriter<ResourceHolder<LongBuffer>>(ioPeon, filenameBase, CompressedLongBufferObjectStrategy.getBufferForOrder(order)));
        return retVal;
    }

    public CompressedLongsSupplierSerializer(int sizePer, GenericIndexedWriter<ResourceHolder<LongBuffer>> flattener) {
        this.sizePer = sizePer;
        this.flattener = flattener;
        this.endBuffer = LongBuffer.allocate(sizePer);
        this.endBuffer.mark();
    }

    public void open() throws IOException {
        this.flattener.open();
    }

    public int size() {
        return this.numInserted;
    }

    public void add(long value) throws IOException {
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write((ResourceHolder<LongBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
            this.endBuffer = LongBuffer.allocate(this.sizePer);
            this.endBuffer.mark();
        }
        this.endBuffer.put(value);
        ++this.numInserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAndConsolidate(OutputSupplier<? extends OutputStream> consolidatedOut) throws IOException {
        this.endBuffer.limit(this.endBuffer.position());
        this.endBuffer.rewind();
        this.flattener.write((ResourceHolder<LongBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
        this.endBuffer = null;
        this.flattener.close();
        OutputStream out = null;
        try {
            out = (OutputStream)consolidatedOut.getOutput();
            out.write(1);
            out.write(Ints.toByteArray((int)this.numInserted));
            out.write(Ints.toByteArray((int)this.sizePer));
            ByteStreams.copy(this.flattener.combineStreams(), (OutputStream)out);
        }
        finally {
            Closeables.closeQuietly((Closeable)out);
        }
    }
}

