/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.Closeables;
import com.google.common.primitives.Ints;
import com.metamx.common.IAE;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.data.CompressedLongBufferObjectStrategy;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.IndexedLongs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;

public class CompressedLongsIndexedSupplier
implements Supplier<IndexedLongs> {
    public static final byte version = 1;
    private final int totalSize;
    private final int sizePer;
    private final GenericIndexed<ResourceHolder<LongBuffer>> baseLongBuffers;

    CompressedLongsIndexedSupplier(int totalSize, int sizePer, GenericIndexed<ResourceHolder<LongBuffer>> baseLongBuffers) {
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.baseLongBuffers = baseLongBuffers;
    }

    public int size() {
        return this.totalSize;
    }

    public IndexedLongs get() {
        return new IndexedLongs(){
            int currIndex = -1;
            ResourceHolder<LongBuffer> holder;
            LongBuffer buffer;

            @Override
            public int size() {
                return CompressedLongsIndexedSupplier.this.totalSize;
            }

            @Override
            public long get(int index) {
                int bufferNum = index / CompressedLongsIndexedSupplier.this.sizePer;
                int bufferIndex = index % CompressedLongsIndexedSupplier.this.sizePer;
                if (bufferNum != this.currIndex) {
                    this.loadBuffer(bufferNum);
                }
                return this.buffer.get(this.buffer.position() + bufferIndex);
            }

            @Override
            public void fill(int index, long[] toFill) {
                if (CompressedLongsIndexedSupplier.this.totalSize - index < toFill.length) {
                    throw new IndexOutOfBoundsException(String.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, CompressedLongsIndexedSupplier.this.totalSize));
                }
                int bufferNum = index / CompressedLongsIndexedSupplier.this.sizePer;
                int bufferIndex = index % CompressedLongsIndexedSupplier.this.sizePer;
                int leftToFill = toFill.length;
                while (leftToFill > 0) {
                    if (bufferNum != this.currIndex) {
                        this.loadBuffer(bufferNum);
                    }
                    this.buffer.mark();
                    this.buffer.position(this.buffer.position() + bufferIndex);
                    int numToGet = Math.min(this.buffer.remaining(), leftToFill);
                    this.buffer.get(toFill, toFill.length - leftToFill, numToGet);
                    this.buffer.reset();
                    leftToFill -= numToGet;
                    ++bufferNum;
                    bufferIndex = 0;
                }
            }

            private void loadBuffer(int bufferNum) {
                Closeables.closeQuietly(this.holder);
                this.holder = (ResourceHolder)CompressedLongsIndexedSupplier.this.baseLongBuffers.get(bufferNum);
                this.buffer = (LongBuffer)this.holder.get();
                this.currIndex = bufferNum;
            }

            @Override
            public int binarySearch(long key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int binarySearch(long key, int from, int to) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "CompressedLongsIndexedSupplier_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + CompressedLongsIndexedSupplier.this.sizePer + ", numChunks=" + CompressedLongsIndexedSupplier.this.baseLongBuffers.size() + ", totalSize=" + CompressedLongsIndexedSupplier.this.totalSize + '}';
            }

            @Override
            public void close() throws IOException {
                Closeables.close(this.holder, (boolean)false);
            }
        };
    }

    public long getSerializedSize() {
        return this.baseLongBuffers.getSerializedSize() + 1L + 4L + 4L;
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{1}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.totalSize)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.sizePer)));
        this.baseLongBuffers.writeToChannel(channel);
    }

    public CompressedLongsIndexedSupplier convertByteOrder(ByteOrder order) {
        return new CompressedLongsIndexedSupplier(this.totalSize, this.sizePer, GenericIndexed.fromIterable(this.baseLongBuffers, CompressedLongBufferObjectStrategy.getBufferForOrder(order)));
    }

    GenericIndexed<ResourceHolder<LongBuffer>> getBaseLongBuffers() {
        return this.baseLongBuffers;
    }

    public static CompressedLongsIndexedSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1) {
            return new CompressedLongsIndexedSupplier(buffer.getInt(), buffer.getInt(), GenericIndexed.read(buffer, CompressedLongBufferObjectStrategy.getBufferForOrder(order)));
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }

    public static CompressedLongsIndexedSupplier fromLongBuffer(LongBuffer buffer, ByteOrder byteOrder) {
        return CompressedLongsIndexedSupplier.fromLongBuffer(buffer, 8191, byteOrder);
    }

    public static CompressedLongsIndexedSupplier fromLongBuffer(final LongBuffer buffer, final int chunkFactor, ByteOrder byteOrder) {
        Preconditions.checkArgument((chunkFactor * 8 <= 65535 ? 1 : 0) != 0, (String)"Chunks must be <= 64k bytes. chunkFactor was[%s]", (Object[])new Object[]{chunkFactor});
        return new CompressedLongsIndexedSupplier(buffer.remaining(), chunkFactor, GenericIndexed.fromIterable(new Iterable<ResourceHolder<LongBuffer>>(){

            @Override
            public Iterator<ResourceHolder<LongBuffer>> iterator() {
                return new Iterator<ResourceHolder<LongBuffer>>(){
                    LongBuffer myBuffer;
                    {
                        this.myBuffer = buffer.asReadOnlyBuffer();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myBuffer.hasRemaining();
                    }

                    @Override
                    public ResourceHolder<LongBuffer> next() {
                        LongBuffer retVal = this.myBuffer.asReadOnlyBuffer();
                        if (chunkFactor < this.myBuffer.remaining()) {
                            retVal.limit(retVal.position() + chunkFactor);
                        }
                        this.myBuffer.position(this.myBuffer.position() + retVal.remaining());
                        return StupidResourceHolder.create((Object)retVal);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, CompressedLongBufferObjectStrategy.getBufferForOrder(byteOrder)));
    }
}

