/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Ordering;
import io.druid.segment.data.CompressedObjectStrategy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

public class CompressedLongBufferObjectStrategy
extends CompressedObjectStrategy<LongBuffer> {
    public static CompressedLongBufferObjectStrategy getBufferForOrder(ByteOrder order) {
        return new CompressedLongBufferObjectStrategy(order);
    }

    private CompressedLongBufferObjectStrategy(ByteOrder order) {
        super(order, new CompressedObjectStrategy.BufferConverter<LongBuffer>(){

            @Override
            public LongBuffer convert(ByteBuffer buf) {
                return buf.asLongBuffer();
            }

            @Override
            public int compare(LongBuffer lhs, LongBuffer rhs) {
                return Ordering.natural().nullsFirst().compare((Object)lhs, (Object)rhs);
            }

            @Override
            public int sizeOf(int count) {
                return count * 8;
            }

            @Override
            public LongBuffer combine(ByteBuffer into, LongBuffer from) {
                return into.asLongBuffer().put(from);
            }
        });
    }
}

