/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.Closeables;
import com.google.common.primitives.Ints;
import com.metamx.common.IAE;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.data.CompressedFloatBufferObjectStrategy;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.IndexedFloats;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;

public class CompressedFloatsIndexedSupplier
implements Supplier<IndexedFloats> {
    public static final byte version = 1;
    public static final int MAX_FLOATS_IN_BUFFER = 16383;
    private final int totalSize;
    private final int sizePer;
    private final GenericIndexed<ResourceHolder<FloatBuffer>> baseFloatBuffers;

    CompressedFloatsIndexedSupplier(int totalSize, int sizePer, GenericIndexed<ResourceHolder<FloatBuffer>> baseFloatBuffers) {
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.baseFloatBuffers = baseFloatBuffers;
    }

    public int size() {
        return this.totalSize;
    }

    public IndexedFloats get() {
        return new IndexedFloats(){
            int currIndex = -1;
            ResourceHolder<FloatBuffer> holder;
            FloatBuffer buffer;

            @Override
            public int size() {
                return CompressedFloatsIndexedSupplier.this.totalSize;
            }

            @Override
            public float get(int index) {
                int bufferNum = index / CompressedFloatsIndexedSupplier.this.sizePer;
                int bufferIndex = index % CompressedFloatsIndexedSupplier.this.sizePer;
                if (bufferNum != this.currIndex) {
                    this.loadBuffer(bufferNum);
                }
                return this.buffer.get(this.buffer.position() + bufferIndex);
            }

            @Override
            public void fill(int index, float[] toFill) {
                if (CompressedFloatsIndexedSupplier.this.totalSize - index < toFill.length) {
                    throw new IndexOutOfBoundsException(String.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, CompressedFloatsIndexedSupplier.this.totalSize));
                }
                int bufferNum = index / CompressedFloatsIndexedSupplier.this.sizePer;
                int bufferIndex = index % CompressedFloatsIndexedSupplier.this.sizePer;
                int leftToFill = toFill.length;
                while (leftToFill > 0) {
                    if (bufferNum != this.currIndex) {
                        this.loadBuffer(bufferNum);
                    }
                    this.buffer.mark();
                    this.buffer.position(this.buffer.position() + bufferIndex);
                    int numToGet = Math.min(this.buffer.remaining(), leftToFill);
                    this.buffer.get(toFill, toFill.length - leftToFill, numToGet);
                    this.buffer.reset();
                    leftToFill -= numToGet;
                    ++bufferNum;
                    bufferIndex = 0;
                }
            }

            private void loadBuffer(int bufferNum) {
                Closeables.closeQuietly(this.holder);
                this.holder = (ResourceHolder)CompressedFloatsIndexedSupplier.this.baseFloatBuffers.get(bufferNum);
                this.buffer = (FloatBuffer)this.holder.get();
                this.currIndex = bufferNum;
            }

            public String toString() {
                return "CompressedFloatsIndexedSupplier_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + CompressedFloatsIndexedSupplier.this.sizePer + ", numChunks=" + CompressedFloatsIndexedSupplier.this.baseFloatBuffers.size() + ", totalSize=" + CompressedFloatsIndexedSupplier.this.totalSize + '}';
            }

            @Override
            public void close() throws IOException {
                Closeables.close(this.holder, (boolean)false);
            }
        };
    }

    public long getSerializedSize() {
        return this.baseFloatBuffers.getSerializedSize() + 1L + 4L + 4L;
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{1}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.totalSize)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.sizePer)));
        this.baseFloatBuffers.writeToChannel(channel);
    }

    public CompressedFloatsIndexedSupplier convertByteOrder(ByteOrder order) {
        return new CompressedFloatsIndexedSupplier(this.totalSize, this.sizePer, GenericIndexed.fromIterable(this.baseFloatBuffers, CompressedFloatBufferObjectStrategy.getBufferForOrder(order)));
    }

    GenericIndexed<ResourceHolder<FloatBuffer>> getBaseFloatBuffers() {
        return this.baseFloatBuffers;
    }

    public static int numFloatsInBuffer(int numFloatsInChunk) {
        return 16383 - 16383 % numFloatsInChunk;
    }

    public static CompressedFloatsIndexedSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1) {
            return new CompressedFloatsIndexedSupplier(buffer.getInt(), buffer.getInt(), GenericIndexed.read(buffer, CompressedFloatBufferObjectStrategy.getBufferForOrder(order)));
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }

    public static CompressedFloatsIndexedSupplier fromFloatBuffer(FloatBuffer buffer, ByteOrder order) {
        return CompressedFloatsIndexedSupplier.fromFloatBuffer(buffer, 16383, order);
    }

    public static CompressedFloatsIndexedSupplier fromFloatBuffer(final FloatBuffer buffer, final int chunkFactor, ByteOrder order) {
        Preconditions.checkArgument((chunkFactor * 4 <= 65535 ? 1 : 0) != 0, (String)"Chunks must be <= 64k bytes. chunkFactor was[%s]", (Object[])new Object[]{chunkFactor});
        return new CompressedFloatsIndexedSupplier(buffer.remaining(), chunkFactor, GenericIndexed.fromIterable(new Iterable<ResourceHolder<FloatBuffer>>(){

            @Override
            public Iterator<ResourceHolder<FloatBuffer>> iterator() {
                return new Iterator<ResourceHolder<FloatBuffer>>(){
                    FloatBuffer myBuffer;
                    {
                        this.myBuffer = buffer.asReadOnlyBuffer();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myBuffer.hasRemaining();
                    }

                    @Override
                    public ResourceHolder<FloatBuffer> next() {
                        FloatBuffer retVal = this.myBuffer.asReadOnlyBuffer();
                        if (chunkFactor < this.myBuffer.remaining()) {
                            retVal.limit(retVal.position() + chunkFactor);
                        }
                        this.myBuffer.position(this.myBuffer.position() + retVal.remaining());
                        return StupidResourceHolder.create((Object)retVal);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, CompressedFloatBufferObjectStrategy.getBufferForOrder(order)));
    }
}

