/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.metamx.common.io.smoosh.SmooshedFileMapper;
import io.druid.segment.QueryableIndex;
import io.druid.segment.column.Column;
import io.druid.segment.data.Indexed;
import java.io.IOException;
import java.util.Map;
import org.joda.time.Interval;

public class SimpleQueryableIndex
implements QueryableIndex {
    private final Interval dataInterval;
    private final Indexed<String> columnNames;
    private final Indexed<String> availableDimensions;
    private final Column timeColumn;
    private final Map<String, Column> otherColumns;
    private final SmooshedFileMapper fileMapper;

    public SimpleQueryableIndex(Interval dataInterval, Indexed<String> columnNames, Indexed<String> dimNames, Column timeColumn, Map<String, Column> otherColumns, SmooshedFileMapper fileMapper) {
        this.dataInterval = dataInterval;
        this.columnNames = columnNames;
        this.availableDimensions = dimNames;
        this.timeColumn = timeColumn;
        this.otherColumns = otherColumns;
        this.fileMapper = fileMapper;
    }

    @Override
    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Override
    public int getNumRows() {
        return this.timeColumn.getLength();
    }

    @Override
    public Indexed<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.availableDimensions;
    }

    @Override
    public Column getTimeColumn() {
        return this.timeColumn;
    }

    @Override
    public Column getColumn(String columnName) {
        return this.otherColumns.get(columnName);
    }

    @Override
    public void close() throws IOException {
        this.fileMapper.close();
    }
}

