/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.metamx.common.collect.MoreIterators;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.guava.FunctionalIterator;
import io.druid.granularity.QueryGranularity;
import io.druid.query.filter.Filter;
import io.druid.segment.Capabilities;
import io.druid.segment.ColumnSelector;
import io.druid.segment.ColumnSelectorBitmapIndexSelector;
import io.druid.segment.ConciseOffset;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.QueryableIndex;
import io.druid.segment.StorageAdapter;
import io.druid.segment.TimestampColumnSelector;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ComplexColumn;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.Offset;
import io.druid.segment.data.SingleIndexedInts;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class QueryableIndexStorageAdapter
implements StorageAdapter {
    private final QueryableIndex index;

    public QueryableIndexStorageAdapter(QueryableIndex index) {
        this.index = index;
    }

    @Override
    public String getSegmentIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval() {
        return this.index.getDataInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.index.getAvailableDimensions();
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return Sets.difference((Set)Sets.newHashSet(this.index.getColumnNames()), (Set)Sets.newHashSet(this.index.getAvailableDimensions()));
    }

    @Override
    public int getDimensionCardinality(String dimension) {
        if (dimension == null) {
            return 0;
        }
        Column column = this.index.getColumn(dimension.toLowerCase());
        if (column == null) {
            return 0;
        }
        if (!column.getCapabilities().isDictionaryEncoded()) {
            throw new UnsupportedOperationException("Only know cardinality of dictionary encoded columns.");
        }
        return column.getDictionaryEncoding().getCardinality();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateTime getMinTime() {
        DateTime dateTime;
        GenericColumn column = null;
        try {
            column = this.index.getTimeColumn().getGenericColumn();
            dateTime = new DateTime(column.getLongSingleValueRow(0));
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(column);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)column);
        return dateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateTime getMaxTime() {
        DateTime dateTime;
        GenericColumn column = null;
        try {
            column = this.index.getTimeColumn().getGenericColumn();
            dateTime = new DateTime(column.getLongSingleValueRow(column.length() - 1));
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(column);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)column);
        return dateTime;
    }

    @Override
    public Capabilities getCapabilities() {
        return Capabilities.builder().dimensionValuesSorted(true).build();
    }

    @Override
    public Iterable<Cursor> makeCursors(Filter filter, Interval interval, QueryGranularity gran) {
        Iterable<Cursor> iterable;
        Interval actualInterval = interval;
        Interval dataInterval = new Interval(this.getMinTime().getMillis(), gran.next(this.getMaxTime().getMillis()));
        if (!actualInterval.overlaps((ReadableInterval)dataInterval)) {
            return ImmutableList.of();
        }
        if (actualInterval.getStart().isBefore((ReadableInstant)dataInterval.getStart())) {
            actualInterval = actualInterval.withStart((ReadableInstant)dataInterval.getStart());
        }
        if (actualInterval.getEnd().isAfter((ReadableInstant)dataInterval.getEnd())) {
            actualInterval = actualInterval.withEnd((ReadableInstant)dataInterval.getEnd());
        }
        if (filter == null) {
            iterable = new NoFilterCursorIterable(this.index, actualInterval, gran);
        } else {
            ConciseOffset offset = new ConciseOffset(filter.goConcise(new ColumnSelectorBitmapIndexSelector(this.index)));
            iterable = new CursorIterable(this.index, actualInterval, gran, offset);
        }
        return FunctionalIterable.create((Iterable)iterable).keep(Functions.identity());
    }

    private static class NullDimensionSelector
    implements DimensionSelector {
        private NullDimensionSelector() {
        }

        @Override
        public IndexedInts getRow() {
            return new SingleIndexedInts(0);
        }

        @Override
        public int getValueCardinality() {
            return 1;
        }

        @Override
        public String lookupName(int id) {
            return "";
        }

        @Override
        public int lookupId(String name) {
            return 0;
        }
    }

    private static class NoFilterCursorIterable
    implements Iterable<Cursor> {
        private final ColumnSelector index;
        private final Interval interval;
        private final QueryGranularity gran;

        public NoFilterCursorIterable(ColumnSelector index, Interval interval, QueryGranularity gran) {
            this.index = index;
            this.interval = interval;
            this.gran = gran;
        }

        @Override
        public Iterator<Cursor> iterator() {
            final HashMap genericColumnCache = Maps.newHashMap();
            final HashMap complexColumnCache = Maps.newHashMap();
            final HashMap objectColumnCache = Maps.newHashMap();
            final GenericColumn timestamps = this.index.getTimeColumn().getGenericColumn();
            FunctionalIterator retVal = FunctionalIterator.create(this.gran.iterable(this.interval.getStartMillis(), this.interval.getEndMillis()).iterator()).transform((Function)new Function<Long, Cursor>(){
                private int currRow = 0;

                public Cursor apply(final Long input) {
                    long timeStart = Math.max(NoFilterCursorIterable.this.interval.getStartMillis(), input);
                    while (this.currRow < timestamps.length() && timestamps.getLongSingleValueRow(this.currRow) < timeStart) {
                        ++this.currRow;
                    }
                    return new Cursor(){
                        private final DateTime myBucket;
                        private final long nextBucket;
                        private final int initRow;
                        {
                            this.myBucket = NoFilterCursorIterable.this.gran.toDateTime(input);
                            this.nextBucket = Math.min(NoFilterCursorIterable.this.gran.next(this.myBucket.getMillis()), NoFilterCursorIterable.this.interval.getEndMillis());
                            this.initRow = currRow;
                        }

                        @Override
                        public DateTime getTime() {
                            return this.myBucket;
                        }

                        @Override
                        public void advance() {
                            ++currRow;
                        }

                        @Override
                        public void advanceTo(int offset) {
                            currRow += offset;
                        }

                        @Override
                        public boolean isDone() {
                            return currRow >= timestamps.length() || timestamps.getLongSingleValueRow(currRow) >= this.nextBucket;
                        }

                        @Override
                        public void reset() {
                            currRow = this.initRow;
                        }

                        @Override
                        public TimestampColumnSelector makeTimestampColumnSelector() {
                            return new TimestampColumnSelector(){

                                @Override
                                public long getTimestamp() {
                                    return timestamps.getLongSingleValueRow(currRow);
                                }
                            };
                        }

                        @Override
                        public DimensionSelector makeDimensionSelector(String dimension) {
                            String dimensionName = dimension.toLowerCase();
                            Column column = NoFilterCursorIterable.this.index.getColumn(dimensionName);
                            if (column == null) {
                                return null;
                            }
                            final DictionaryEncodedColumn dict = column.getDictionaryEncoding();
                            if (dict == null) {
                                return null;
                            }
                            if (column.getCapabilities().hasMultipleValues()) {
                                return new DimensionSelector(){

                                    @Override
                                    public IndexedInts getRow() {
                                        return dict.getMultiValueRow(currRow);
                                    }

                                    @Override
                                    public int getValueCardinality() {
                                        return dict.getCardinality();
                                    }

                                    @Override
                                    public String lookupName(int id) {
                                        String retVal = dict.lookupName(id);
                                        return retVal == null ? "" : retVal;
                                    }

                                    @Override
                                    public int lookupId(String name) {
                                        return dict.lookupId(name);
                                    }
                                };
                            }
                            return new DimensionSelector(){

                                @Override
                                public IndexedInts getRow() {
                                    return new SingleIndexedInts(dict.getSingleValueRow(currRow));
                                }

                                @Override
                                public int getValueCardinality() {
                                    return dict.getCardinality();
                                }

                                @Override
                                public String lookupName(int id) {
                                    return dict.lookupName(id);
                                }

                                @Override
                                public int lookupId(String name) {
                                    return dict.lookupId(name);
                                }
                            };
                        }

                        @Override
                        public FloatColumnSelector makeFloatColumnSelector(String columnName) {
                            Column holder;
                            String metricName = columnName.toLowerCase();
                            GenericColumn cachedMetricVals = (GenericColumn)genericColumnCache.get(metricName);
                            if (cachedMetricVals == null && (holder = NoFilterCursorIterable.this.index.getColumn(metricName)) != null && holder.getCapabilities().getType() == ValueType.FLOAT) {
                                cachedMetricVals = holder.getGenericColumn();
                                genericColumnCache.put(metricName, cachedMetricVals);
                            }
                            if (cachedMetricVals == null) {
                                return new FloatColumnSelector(){

                                    @Override
                                    public float get() {
                                        return 0.0f;
                                    }
                                };
                            }
                            final GenericColumn metricVals = cachedMetricVals;
                            return new FloatColumnSelector(){

                                @Override
                                public float get() {
                                    return metricVals.getFloatSingleValueRow(currRow);
                                }
                            };
                        }

                        @Override
                        public ObjectColumnSelector makeObjectColumnSelector(String column) {
                            Object columnVals;
                            ValueType type;
                            String columnName = column.toLowerCase();
                            Object cachedColumnVals = objectColumnCache.get(columnName);
                            if (cachedColumnVals == null) {
                                Column holder = NoFilterCursorIterable.this.index.getColumn(columnName);
                                if (holder != null) {
                                    if (holder.getCapabilities().hasMultipleValues()) {
                                        throw new UnsupportedOperationException("makeObjectColumnSelector does not support multivalued columns");
                                    }
                                    type = holder.getCapabilities().getType();
                                    cachedColumnVals = holder.getCapabilities().isDictionaryEncoded() ? holder.getDictionaryEncoding() : (type == ValueType.COMPLEX ? holder.getComplexColumn() : holder.getGenericColumn());
                                }
                                if (cachedColumnVals != null) {
                                    objectColumnCache.put(columnName, cachedColumnVals);
                                }
                            }
                            if (cachedColumnVals == null) {
                                return null;
                            }
                            if (cachedColumnVals instanceof GenericColumn) {
                                columnVals = (GenericColumn)cachedColumnVals;
                                type = columnVals.getType();
                                if (type == ValueType.FLOAT) {
                                    return new ObjectColumnSelector<Float>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return Float.TYPE;
                                        }

                                        @Override
                                        public Float get() {
                                            return Float.valueOf(this.val$columnVals.getFloatSingleValueRow(currRow));
                                        }
                                    };
                                }
                                if (type == ValueType.LONG) {
                                    return new ObjectColumnSelector<Long>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return Long.TYPE;
                                        }

                                        @Override
                                        public Long get() {
                                            return this.val$columnVals.getLongSingleValueRow(currRow);
                                        }
                                    };
                                }
                                if (type == ValueType.STRING) {
                                    return new ObjectColumnSelector<String>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return String.class;
                                        }

                                        @Override
                                        public String get() {
                                            return this.val$columnVals.getStringSingleValueRow(currRow);
                                        }
                                    };
                                }
                            }
                            if (cachedColumnVals instanceof DictionaryEncodedColumn) {
                                columnVals = (DictionaryEncodedColumn)cachedColumnVals;
                                return new ObjectColumnSelector<String>((DictionaryEncodedColumn)columnVals){
                                    final /* synthetic */ DictionaryEncodedColumn val$columnVals;
                                    {
                                        this.val$columnVals = dictionaryEncodedColumn;
                                    }

                                    @Override
                                    public Class classOfObject() {
                                        return String.class;
                                    }

                                    @Override
                                    public String get() {
                                        return this.val$columnVals.lookupName(this.val$columnVals.getSingleValueRow(currRow));
                                    }
                                };
                            }
                            columnVals = (ComplexColumn)cachedColumnVals;
                            return new ObjectColumnSelector((ComplexColumn)columnVals){
                                final /* synthetic */ ComplexColumn val$columnVals;
                                {
                                    this.val$columnVals = complexColumn;
                                }

                                public Class classOfObject() {
                                    return this.val$columnVals.getClazz();
                                }

                                public Object get() {
                                    return this.val$columnVals.getRowValue(currRow);
                                }
                            };
                        }
                    };
                }
            });
            return MoreIterators.after((Iterator)retVal, (Runnable)new Runnable(){

                @Override
                public void run() {
                    Closeables.closeQuietly((Closeable)timestamps);
                    for (GenericColumn column : genericColumnCache.values()) {
                        Closeables.closeQuietly((Closeable)column);
                    }
                    for (ComplexColumn complexColumn : complexColumnCache.values()) {
                        Closeables.closeQuietly((Closeable)complexColumn);
                    }
                    for (GenericColumn column : objectColumnCache.values()) {
                        if (!(column instanceof Closeable)) continue;
                        Closeables.closeQuietly((Closeable)column);
                    }
                }
            });
        }
    }

    private static class TimestampCheckingOffset
    implements Offset {
        private final Offset baseOffset;
        private final GenericColumn timestamps;
        private final long threshold;

        public TimestampCheckingOffset(Offset baseOffset, GenericColumn timestamps, long threshold) {
            this.baseOffset = baseOffset;
            this.timestamps = timestamps;
            this.threshold = threshold;
        }

        @Override
        public int getOffset() {
            return this.baseOffset.getOffset();
        }

        @Override
        public Offset clone() {
            return new TimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.threshold);
        }

        @Override
        public boolean withinBounds() {
            return this.baseOffset.withinBounds() && this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset()) < this.threshold;
        }

        @Override
        public void increment() {
            this.baseOffset.increment();
        }
    }

    private static class CursorIterable
    implements Iterable<Cursor> {
        private final ColumnSelector index;
        private final Interval interval;
        private final QueryGranularity gran;
        private final Offset offset;

        public CursorIterable(ColumnSelector index, Interval interval, QueryGranularity gran, Offset offset) {
            this.index = index;
            this.interval = interval;
            this.gran = gran;
            this.offset = offset;
        }

        @Override
        public Iterator<Cursor> iterator() {
            final Offset baseOffset = this.offset.clone();
            final HashMap genericColumnCache = Maps.newHashMap();
            final HashMap complexColumnCache = Maps.newHashMap();
            final HashMap objectColumnCache = Maps.newHashMap();
            final GenericColumn timestamps = this.index.getTimeColumn().getGenericColumn();
            FunctionalIterator retVal = FunctionalIterator.create(this.gran.iterable(this.interval.getStartMillis(), this.interval.getEndMillis()).iterator()).transform((Function)new Function<Long, Cursor>(){

                public Cursor apply(final Long input) {
                    long timeStart = Math.max(CursorIterable.this.interval.getStartMillis(), input);
                    while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) < timeStart) {
                        baseOffset.increment();
                    }
                    final TimestampCheckingOffset offset = new TimestampCheckingOffset(baseOffset, timestamps, Math.min(CursorIterable.this.interval.getEndMillis(), CursorIterable.this.gran.next(input)));
                    return new Cursor(){
                        private final Offset initOffset;
                        private final DateTime myBucket;
                        private Offset cursorOffset;
                        {
                            this.initOffset = offset.clone();
                            this.myBucket = CursorIterable.this.gran.toDateTime(input);
                            this.cursorOffset = offset;
                        }

                        @Override
                        public DateTime getTime() {
                            return this.myBucket;
                        }

                        @Override
                        public void advance() {
                            this.cursorOffset.increment();
                        }

                        @Override
                        public void advanceTo(int offset2) {
                            for (int count = 0; count < offset2 && !this.isDone(); ++count) {
                                this.advance();
                            }
                        }

                        @Override
                        public boolean isDone() {
                            return !this.cursorOffset.withinBounds();
                        }

                        @Override
                        public void reset() {
                            this.cursorOffset = this.initOffset.clone();
                        }

                        @Override
                        public TimestampColumnSelector makeTimestampColumnSelector() {
                            return new TimestampColumnSelector(){

                                @Override
                                public long getTimestamp() {
                                    return timestamps.getLongSingleValueRow(cursorOffset.getOffset());
                                }
                            };
                        }

                        @Override
                        public DimensionSelector makeDimensionSelector(String dimension) {
                            String dimensionName = dimension.toLowerCase();
                            Column columnDesc = CursorIterable.this.index.getColumn(dimensionName);
                            if (columnDesc == null) {
                                return null;
                            }
                            final DictionaryEncodedColumn column = columnDesc.getDictionaryEncoding();
                            if (column == null) {
                                return null;
                            }
                            if (columnDesc.getCapabilities().hasMultipleValues()) {
                                return new DimensionSelector(){

                                    @Override
                                    public IndexedInts getRow() {
                                        return column.getMultiValueRow(cursorOffset.getOffset());
                                    }

                                    @Override
                                    public int getValueCardinality() {
                                        return column.getCardinality();
                                    }

                                    @Override
                                    public String lookupName(int id) {
                                        String retVal = column.lookupName(id);
                                        return retVal == null ? "" : retVal;
                                    }

                                    @Override
                                    public int lookupId(String name) {
                                        return column.lookupId(name);
                                    }
                                };
                            }
                            return new DimensionSelector(){

                                @Override
                                public IndexedInts getRow() {
                                    return new SingleIndexedInts(column.getSingleValueRow(cursorOffset.getOffset()));
                                }

                                @Override
                                public int getValueCardinality() {
                                    return column.getCardinality();
                                }

                                @Override
                                public String lookupName(int id) {
                                    return column.lookupName(id);
                                }

                                @Override
                                public int lookupId(String name) {
                                    return column.lookupId(name);
                                }
                            };
                        }

                        @Override
                        public FloatColumnSelector makeFloatColumnSelector(String columnName) {
                            Column holder;
                            String metricName = columnName.toLowerCase();
                            GenericColumn cachedMetricVals = (GenericColumn)genericColumnCache.get(metricName);
                            if (cachedMetricVals == null && (holder = CursorIterable.this.index.getColumn(metricName)) != null && holder.getCapabilities().getType() == ValueType.FLOAT) {
                                cachedMetricVals = holder.getGenericColumn();
                                genericColumnCache.put(metricName, cachedMetricVals);
                            }
                            if (cachedMetricVals == null) {
                                return new FloatColumnSelector(){

                                    @Override
                                    public float get() {
                                        return 0.0f;
                                    }
                                };
                            }
                            final GenericColumn metricVals = cachedMetricVals;
                            return new FloatColumnSelector(){

                                @Override
                                public float get() {
                                    return metricVals.getFloatSingleValueRow(cursorOffset.getOffset());
                                }
                            };
                        }

                        @Override
                        public ObjectColumnSelector makeObjectColumnSelector(String column) {
                            Object columnVals;
                            String columnName = column.toLowerCase();
                            Object cachedColumnVals = objectColumnCache.get(columnName);
                            if (cachedColumnVals == null) {
                                Column holder = CursorIterable.this.index.getColumn(columnName);
                                if (holder != null) {
                                    ColumnCapabilities capabilities = holder.getCapabilities();
                                    if (capabilities.hasMultipleValues()) {
                                        throw new UnsupportedOperationException("makeObjectColumnSelector does not support multivalued columns");
                                    }
                                    cachedColumnVals = capabilities.isDictionaryEncoded() ? holder.getDictionaryEncoding() : (capabilities.getType() == ValueType.COMPLEX ? holder.getComplexColumn() : holder.getGenericColumn());
                                }
                                if (cachedColumnVals != null) {
                                    objectColumnCache.put(columnName, cachedColumnVals);
                                }
                            }
                            if (cachedColumnVals == null) {
                                return null;
                            }
                            if (cachedColumnVals instanceof GenericColumn) {
                                columnVals = (GenericColumn)cachedColumnVals;
                                ValueType type = columnVals.getType();
                                if (type == ValueType.FLOAT) {
                                    return new ObjectColumnSelector<Float>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return Float.TYPE;
                                        }

                                        @Override
                                        public Float get() {
                                            return Float.valueOf(this.val$columnVals.getFloatSingleValueRow(cursorOffset.getOffset()));
                                        }
                                    };
                                }
                                if (type == ValueType.LONG) {
                                    return new ObjectColumnSelector<Long>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return Long.TYPE;
                                        }

                                        @Override
                                        public Long get() {
                                            return this.val$columnVals.getLongSingleValueRow(cursorOffset.getOffset());
                                        }
                                    };
                                }
                                if (type == ValueType.STRING) {
                                    return new ObjectColumnSelector<String>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return String.class;
                                        }

                                        @Override
                                        public String get() {
                                            return this.val$columnVals.getStringSingleValueRow(cursorOffset.getOffset());
                                        }
                                    };
                                }
                            }
                            if (cachedColumnVals instanceof DictionaryEncodedColumn) {
                                columnVals = (DictionaryEncodedColumn)cachedColumnVals;
                                return new ObjectColumnSelector<String>((DictionaryEncodedColumn)columnVals){
                                    final /* synthetic */ DictionaryEncodedColumn val$columnVals;
                                    {
                                        this.val$columnVals = dictionaryEncodedColumn;
                                    }

                                    @Override
                                    public Class classOfObject() {
                                        return String.class;
                                    }

                                    @Override
                                    public String get() {
                                        return this.val$columnVals.lookupName(this.val$columnVals.getSingleValueRow(cursorOffset.getOffset()));
                                    }
                                };
                            }
                            columnVals = (ComplexColumn)cachedColumnVals;
                            return new ObjectColumnSelector((ComplexColumn)columnVals){
                                final /* synthetic */ ComplexColumn val$columnVals;
                                {
                                    this.val$columnVals = complexColumn;
                                }

                                public Class classOfObject() {
                                    return this.val$columnVals.getClazz();
                                }

                                public Object get() {
                                    return this.val$columnVals.getRowValue(cursorOffset.getOffset());
                                }
                            };
                        }
                    };
                }
            });
            return MoreIterators.after((Iterator)retVal, (Runnable)new Runnable(){

                @Override
                public void run() {
                    Closeables.closeQuietly((Closeable)timestamps);
                    for (GenericColumn column : genericColumnCache.values()) {
                        Closeables.closeQuietly((Closeable)column);
                    }
                    for (ComplexColumn complexColumn : complexColumnCache.values()) {
                        Closeables.closeQuietly((Closeable)complexColumn);
                    }
                    for (GenericColumn column : objectColumnCache.values()) {
                        if (!(column instanceof Closeable)) continue;
                        Closeables.closeQuietly((Closeable)column);
                    }
                }
            });
        }
    }
}

