/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexStorageAdapter;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import java.io.IOException;
import org.joda.time.Interval;

public class QueryableIndexSegment
implements Segment {
    private final QueryableIndex index;
    private final String identifier;

    public QueryableIndexSegment(String segmentIdentifier, QueryableIndex index) {
        this.index = index;
        this.identifier = segmentIdentifier;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Interval getDataInterval() {
        return this.index.getDataInterval();
    }

    @Override
    public QueryableIndex asQueryableIndex() {
        return this.index;
    }

    @Override
    public StorageAdapter asStorageAdapter() {
        return new QueryableIndexStorageAdapter(this.index);
    }

    @Override
    public void close() throws IOException {
        this.index.close();
    }
}

