/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.druid.granularity.QueryGranularity;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public enum IndexGranularity {
    MINUTE{
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd/'H'=HH/'M'=mm");
        private final int MILLIS_IN = 60000;

        @Override
        public String toPath(DateTime time) {
            return this.format.print((ReadableInstant)time);
        }

        @Override
        public DateTime increment(DateTime time) {
            return time.plus((ReadablePeriod)Minutes.ONE);
        }

        @Override
        public DateTime increment(DateTime time, int count) {
            return time.plus((ReadablePeriod)Minutes.minutes((int)count));
        }

        @Override
        public long increment(long timeMillis) {
            return timeMillis + 60000L;
        }

        @Override
        public DateTime decrement(DateTime time) {
            return time.minus((ReadablePeriod)Minutes.ONE);
        }

        @Override
        public DateTime decrement(DateTime time, int count) {
            return time.minus((ReadablePeriod)Minutes.minutes((int)count));
        }

        @Override
        public long decrement(long timeMillis) {
            return timeMillis - 60000L;
        }

        @Override
        public long truncate(long timeMillis) {
            return QueryGranularity.MINUTE.truncate(timeMillis);
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfSecond(0);
            mutableDateTime.setSecondOfMinute(0);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Minutes.minutesIn((ReadableInterval)interval).getMinutes();
        }
    }
    ,
    HOUR{
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd/'H'=HH");
        private final int MILLIS_IN = 3600000;

        @Override
        public String toPath(DateTime time) {
            return this.format.print((ReadableInstant)time);
        }

        @Override
        public DateTime increment(DateTime time) {
            return time.plus((ReadablePeriod)Hours.ONE);
        }

        @Override
        public DateTime increment(DateTime time, int count) {
            return time.plus((ReadablePeriod)Hours.hours((int)count));
        }

        @Override
        public long increment(long timeMillis) {
            return timeMillis + 3600000L;
        }

        @Override
        public DateTime decrement(DateTime time) {
            return time.minus((ReadablePeriod)Hours.ONE);
        }

        @Override
        public DateTime decrement(DateTime time, int count) {
            return time.minus((ReadablePeriod)Hours.hours((int)count));
        }

        @Override
        public long decrement(long timeMillis) {
            return timeMillis - 3600000L;
        }

        @Override
        public long truncate(long timeMillis) {
            return QueryGranularity.HOUR.truncate(timeMillis);
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfSecond(0);
            mutableDateTime.setSecondOfMinute(0);
            mutableDateTime.setMinuteOfHour(0);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Hours.hoursIn((ReadableInterval)interval).getHours();
        }
    }
    ,
    DAY{
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd");
        private final int MILLIS_IN = 86400000;

        @Override
        public String toPath(DateTime time) {
            return this.format.print((ReadableInstant)time);
        }

        @Override
        public DateTime increment(DateTime time) {
            return time.plus((ReadablePeriod)Days.ONE);
        }

        @Override
        public DateTime increment(DateTime time, int count) {
            return time.plus((ReadablePeriod)Days.days((int)count));
        }

        @Override
        public long increment(long timeMillis) {
            return timeMillis + 86400000L;
        }

        @Override
        public DateTime decrement(DateTime time) {
            return time.minus((ReadablePeriod)Days.ONE);
        }

        @Override
        public DateTime decrement(DateTime time, int count) {
            return time.minus((ReadablePeriod)Days.days((int)count));
        }

        @Override
        public long decrement(long timeMillis) {
            return timeMillis - 86400000L;
        }

        @Override
        public long truncate(long timeMillis) {
            return QueryGranularity.DAY.truncate(timeMillis);
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfDay(0);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Days.daysIn((ReadableInterval)interval).getDays();
        }
    }
    ,
    WEEK{
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd");
        private final int MILLIS_IN = 604800000;

        @Override
        public String toPath(DateTime time) {
            throw new UnsupportedOperationException("Not Implemented Yet.");
        }

        @Override
        public DateTime increment(DateTime time) {
            return time.plus((ReadablePeriod)Weeks.ONE);
        }

        @Override
        public DateTime increment(DateTime time, int count) {
            return time.plus((ReadablePeriod)Weeks.weeks((int)count));
        }

        @Override
        public long increment(long timeMillis) {
            return timeMillis + 604800000L;
        }

        @Override
        public DateTime decrement(DateTime time) {
            return time.minus((ReadablePeriod)Weeks.ONE);
        }

        @Override
        public DateTime decrement(DateTime time, int count) {
            return time.minus((ReadablePeriod)Weeks.weeks((int)count));
        }

        @Override
        public long decrement(long timeMillis) {
            return timeMillis - 604800000L;
        }

        @Override
        public long truncate(long timeMillis) {
            return this.truncate(new DateTime(timeMillis)).getMillis();
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfDay(0);
            mutableDateTime.setDayOfWeek(1);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Weeks.weeksIn((ReadableInterval)interval).getWeeks();
        }
    }
    ,
    MONTH{
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM");

        @Override
        public String toPath(DateTime time) {
            return this.format.print((ReadableInstant)time);
        }

        @Override
        public DateTime increment(DateTime time) {
            return time.plus((ReadablePeriod)Months.ONE);
        }

        @Override
        public DateTime increment(DateTime time, int count) {
            return time.plus((ReadablePeriod)Months.months((int)count));
        }

        @Override
        public long increment(long timeMillis) {
            return new DateTime(timeMillis).plus((ReadablePeriod)Months.ONE).getMillis();
        }

        @Override
        public DateTime decrement(DateTime time) {
            return time.minus((ReadablePeriod)Months.ONE);
        }

        @Override
        public DateTime decrement(DateTime time, int count) {
            return time.minus((ReadablePeriod)Months.months((int)count));
        }

        @Override
        public long decrement(long timeMillis) {
            return new DateTime(timeMillis).minus((ReadablePeriod)Months.ONE).getMillis();
        }

        @Override
        public long truncate(long timeMillis) {
            return this.truncate(new DateTime(timeMillis)).getMillis();
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfDay(0);
            mutableDateTime.setDayOfMonth(1);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Months.monthsIn((ReadableInterval)interval).getMonths();
        }
    }
    ,
    YEAR{
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"'y'=yyyy");

        @Override
        public String toPath(DateTime time) {
            return this.format.print((ReadableInstant)time);
        }

        @Override
        public DateTime increment(DateTime time) {
            return time.plus((ReadablePeriod)Years.ONE);
        }

        @Override
        public DateTime increment(DateTime time, int count) {
            return time.plus((ReadablePeriod)Years.years((int)count));
        }

        @Override
        public long increment(long timeMillis) {
            return new DateTime(timeMillis).plus((ReadablePeriod)Years.ONE).getMillis();
        }

        @Override
        public DateTime decrement(DateTime time) {
            return time.minus((ReadablePeriod)Years.ONE);
        }

        @Override
        public DateTime decrement(DateTime time, int count) {
            return time.minus((ReadablePeriod)Years.years((int)count));
        }

        @Override
        public long decrement(long timeMillis) {
            return new DateTime(timeMillis).minus((ReadablePeriod)Years.ONE).getMillis();
        }

        @Override
        public long truncate(long timeMillis) {
            return this.truncate(new DateTime(timeMillis)).getMillis();
        }

        @Override
        public DateTime truncate(DateTime time) {
            MutableDateTime mutableDateTime = time.toMutableDateTime();
            mutableDateTime.setMillisOfDay(0);
            mutableDateTime.setDayOfMonth(1);
            mutableDateTime.setMonthOfYear(1);
            return mutableDateTime.toDateTime();
        }

        @Override
        public int numIn(ReadableInterval interval) {
            return Years.yearsIn((ReadableInterval)interval).getYears();
        }
    }
    ,
    LATEST{
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"'y'=yyyy/'m'=MM/'d'=dd/'H'=HH/'M'=mm");

        @Override
        public String toPath(DateTime time) {
            return this.format.print((ReadableInstant)time);
        }

        @Override
        public DateTime increment(DateTime time) {
            throw new UnsupportedOperationException("LATEST exists for client-side only");
        }

        @Override
        public DateTime increment(DateTime time, int count) {
            throw new UnsupportedOperationException("LATEST exists for client-side only");
        }

        @Override
        public long increment(long timeMillis) {
            throw new UnsupportedOperationException("LATEST exists for client-side only");
        }

        @Override
        public DateTime decrement(DateTime time) {
            throw new UnsupportedOperationException("LATEST exists for client-side only");
        }

        @Override
        public DateTime decrement(DateTime time, int count) {
            throw new UnsupportedOperationException("LATEST exists for client-side only");
        }

        @Override
        public long decrement(long timeMillis) {
            throw new UnsupportedOperationException("LATEST exists for client-side only");
        }

        @Override
        public long truncate(long timeMillis) {
            return 0L;
        }

        @Override
        public DateTime truncate(DateTime time) {
            return new DateTime(0L);
        }

        @Override
        public int numIn(ReadableInterval interval) {
            throw new UnsupportedOperationException("LATEST exists for client-side only");
        }
    };


    public abstract String toPath(DateTime var1);

    public abstract DateTime increment(DateTime var1);

    public abstract DateTime increment(DateTime var1, int var2);

    public abstract long increment(long var1);

    public abstract DateTime decrement(DateTime var1);

    public abstract DateTime decrement(DateTime var1, int var2);

    public abstract long decrement(long var1);

    public abstract long truncate(long var1);

    public abstract DateTime truncate(DateTime var1);

    public abstract int numIn(ReadableInterval var1);

    @JsonCreator
    public static IndexGranularity fromString(String s) {
        return IndexGranularity.valueOf(s.toUpperCase());
    }
}

