/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.logger.Logger;
import io.druid.collections.StupidPool;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.filter.Filter;
import io.druid.query.topn.AggregateTopNMetricFirstAlgorithm;
import io.druid.query.topn.DimExtractionTopNAlgorithm;
import io.druid.query.topn.PooledTopNAlgorithm;
import io.druid.query.topn.TopNAlgorithm;
import io.druid.query.topn.TopNAlgorithmSelector;
import io.druid.query.topn.TopNMapFn;
import io.druid.query.topn.TopNParams;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.Capabilities;
import io.druid.segment.Cursor;
import io.druid.segment.StorageAdapter;
import io.druid.segment.filter.Filters;
import java.nio.ByteBuffer;
import java.util.List;
import org.joda.time.Interval;

public class TopNQueryEngine {
    private static final Logger log = new Logger(TopNQueryEngine.class);
    private final StupidPool<ByteBuffer> bufferPool;

    public TopNQueryEngine(StupidPool<ByteBuffer> bufferPool) {
        this.bufferPool = bufferPool;
    }

    public Iterable<Result<TopNResultValue>> query(TopNQuery query, final StorageAdapter adapter) {
        List<Interval> queryIntervals = query.getQuerySegmentSpec().getIntervals();
        Filter filter = Filters.convertDimensionFilters(query.getDimensionsFilter());
        QueryGranularity granularity = query.getGranularity();
        Function<Cursor, Result<TopNResultValue>> mapFn = this.getMapFn(query, adapter);
        Preconditions.checkArgument((queryIntervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{queryIntervals});
        if (mapFn == null) {
            return Lists.newArrayList();
        }
        return FunctionalIterable.create(adapter.makeCursors(filter, queryIntervals.get(0), granularity)).transform((Function)new Function<Cursor, Cursor>(){

            public Cursor apply(Cursor input) {
                log.debug("Running over cursor[%s]", new Object[]{adapter.getInterval(), input.getTime()});
                return input;
            }
        }).keep(mapFn);
    }

    private Function<Cursor, Result<TopNResultValue>> getMapFn(TopNQuery query, StorageAdapter adapter) {
        if (adapter == null) {
            log.warn("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped. Returning empty results.", new Object[0]);
            return null;
        }
        Capabilities capabilities = adapter.getCapabilities();
        int cardinality = adapter.getDimensionCardinality(query.getDimensionSpec().getDimension());
        int numBytesPerRecord = 0;
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            numBytesPerRecord += aggregatorFactory.getMaxIntermediateSize();
        }
        TopNAlgorithmSelector selector = new TopNAlgorithmSelector(cardinality, numBytesPerRecord);
        query.initTopNAlgorithmSelector(selector);
        TopNAlgorithm<Aggregator[][], TopNParams> topNAlgorithm = null;
        topNAlgorithm = selector.isHasDimExtractionFn() ? new DimExtractionTopNAlgorithm(capabilities, query) : (selector.isAggregateAllMetrics() ? new PooledTopNAlgorithm(capabilities, query, this.bufferPool) : (selector.isAggregateTopNMetricFirst() ? new AggregateTopNMetricFirstAlgorithm(capabilities, query, this.bufferPool) : new PooledTopNAlgorithm(capabilities, query, this.bufferPool)));
        return new TopNMapFn(query, topNAlgorithm);
    }
}

