/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.io.Closeables;
import com.metamx.common.Pair;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidPool;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.topn.BaseTopNAlgorithm;
import io.druid.query.topn.TopNMetricSpecBuilder;
import io.druid.query.topn.TopNParams;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNResultBuilder;
import io.druid.segment.Capabilities;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.data.IndexedInts;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;

public class PooledTopNAlgorithm
extends BaseTopNAlgorithm<int[], BufferAggregator[], PooledTopNParams> {
    private final Capabilities capabilities;
    private final TopNQuery query;
    private final Comparator<?> comparator;
    private final StupidPool<ByteBuffer> bufferPool;

    public PooledTopNAlgorithm(Capabilities capabilities, TopNQuery query, StupidPool<ByteBuffer> bufferPool) {
        super(capabilities);
        this.capabilities = capabilities;
        this.query = query;
        this.comparator = query.getTopNMetricSpec().getComparator(query.getAggregatorSpecs(), query.getPostAggregatorSpecs());
        this.bufferPool = bufferPool;
    }

    @Override
    public PooledTopNParams makeInitParams(DimensionSelector dimSelector, Cursor cursor) {
        ResourceHolder resultsBufHolder = this.bufferPool.take();
        ByteBuffer resultsBuf = (ByteBuffer)resultsBufHolder.get();
        resultsBuf.clear();
        final int cardinality = dimSelector.getValueCardinality();
        BaseTopNAlgorithm.BaseArrayProvider<int[]> arrayProvider = new BaseTopNAlgorithm.BaseArrayProvider<int[]>(dimSelector, this.query, this.capabilities){
            private final int[] positions;
            {
                super(x0, x1, x2);
                this.positions = new int[cardinality];
            }

            @Override
            public int[] build() {
                Pair<Integer, Integer> startEnd = this.computeStartEnd(cardinality);
                Arrays.fill(this.positions, 0, (int)((Integer)startEnd.lhs), -2);
                Arrays.fill(this.positions, (int)((Integer)startEnd.lhs), (int)((Integer)startEnd.rhs), -1);
                Arrays.fill(this.positions, (int)((Integer)startEnd.rhs), this.positions.length, -2);
                return this.positions;
            }
        };
        int numBytesToWorkWith = resultsBuf.remaining();
        int[] aggregatorSizes = new int[this.query.getAggregatorSpecs().size()];
        int numBytesPerRecord = 0;
        for (int i = 0; i < this.query.getAggregatorSpecs().size(); ++i) {
            aggregatorSizes[i] = this.query.getAggregatorSpecs().get(i).getMaxIntermediateSize();
            numBytesPerRecord += aggregatorSizes[i];
        }
        int numValuesPerPass = numBytesToWorkWith / numBytesPerRecord;
        return PooledTopNParams.builder().withDimSelector(dimSelector).withCursor(cursor).withCardinality(cardinality).withResultsBufHolder((ResourceHolder<ByteBuffer>)resultsBufHolder).withResultsBuf(resultsBuf).withArrayProvider((TopNMetricSpecBuilder<int[]>)arrayProvider).withNumBytesPerRecord(numBytesPerRecord).withNumValuesPerPass(numValuesPerPass).withAggregatorSizes(aggregatorSizes).build();
    }

    @Override
    public TopNResultBuilder makeResultBuilder(PooledTopNParams params) {
        return this.query.getTopNMetricSpec().getResultBuilder(params.getCursor().getTime(), this.query.getDimensionSpec(), this.query.getThreshold(), this.comparator);
    }

    @Override
    protected int[] makeDimValSelector(PooledTopNParams params, int numProcessed, int numToProcess) {
        TopNMetricSpecBuilder<int[]> arrayProvider = params.getArrayProvider();
        arrayProvider.ignoreFirstN(numProcessed);
        arrayProvider.keepOnlyN(numToProcess);
        return this.query.getTopNMetricSpec().configureOptimizer(arrayProvider).build();
    }

    @Override
    protected int[] updateDimValSelector(int[] dimValSelector, int numProcessed, int numToProcess) {
        int[] retVal = Arrays.copyOf(dimValSelector, dimValSelector.length);
        int validEnd = Math.min(retVal.length, numProcessed + numToProcess);
        int end = Math.max(retVal.length, validEnd);
        Arrays.fill(retVal, 0, numProcessed, -2);
        Arrays.fill(retVal, validEnd, end, -2);
        return retVal;
    }

    @Override
    protected BufferAggregator[] makeDimValAggregateStore(PooledTopNParams params) {
        return PooledTopNAlgorithm.makeBufferAggregators(params.getCursor(), this.query.getAggregatorSpecs());
    }

    @Override
    protected void scanAndAggregate(PooledTopNParams params, int[] positions, BufferAggregator[] theAggregators, int numProcessed) {
        ByteBuffer resultsBuf = params.getResultsBuf();
        int numBytesPerRecord = params.getNumBytesPerRecord();
        int[] aggregatorSizes = params.getAggregatorSizes();
        Cursor cursor = params.getCursor();
        DimensionSelector dimSelector = params.getDimSelector();
        while (!cursor.isDone()) {
            IndexedInts dimValues = dimSelector.getRow();
            block5: for (int i = 0; i < dimValues.size(); ++i) {
                int dimIndex = dimValues.get(i);
                int position = positions[dimIndex];
                switch (position) {
                    case -2: {
                        continue block5;
                    }
                    case -1: {
                        int j;
                        positions[dimIndex] = (dimIndex - numProcessed) * numBytesPerRecord;
                        position = positions[dimIndex];
                        for (j = 0; j < theAggregators.length; ++j) {
                            theAggregators[j].init(resultsBuf, position);
                            position += aggregatorSizes[j];
                        }
                        position = positions[dimIndex];
                    }
                    default: {
                        int j;
                        for (j = 0; j < theAggregators.length; ++j) {
                            theAggregators[j].aggregate(resultsBuf, position);
                            position += aggregatorSizes[j];
                        }
                    }
                }
            }
            cursor.advance();
        }
    }

    @Override
    protected void updateResults(PooledTopNParams params, int[] positions, BufferAggregator[] theAggregators, TopNResultBuilder resultBuilder) {
        ByteBuffer resultsBuf = params.getResultsBuf();
        int[] aggregatorSizes = params.getAggregatorSizes();
        DimensionSelector dimSelector = params.getDimSelector();
        for (int i = 0; i < positions.length; ++i) {
            int position = positions[i];
            if (position < 0) continue;
            Object[] vals = new Object[theAggregators.length];
            for (int j = 0; j < theAggregators.length; ++j) {
                vals[j] = theAggregators[j].get(resultsBuf, position);
                position += aggregatorSizes[j];
            }
            resultBuilder.addEntry(dimSelector.lookupName(i), i, vals, this.query.getAggregatorSpecs(), this.query.getPostAggregatorSpecs());
        }
    }

    @Override
    protected void closeAggregators(BufferAggregator[] bufferAggregators) {
        for (BufferAggregator agg : bufferAggregators) {
            agg.close();
        }
    }

    @Override
    public void cleanup(PooledTopNParams params) {
        ResourceHolder<ByteBuffer> resultsBufHolder = params.getResultsBufHolder();
        if (resultsBufHolder != null) {
            ((ByteBuffer)resultsBufHolder.get()).clear();
        }
        Closeables.closeQuietly(resultsBufHolder);
    }

    public static class PooledTopNParams
    extends TopNParams {
        private final ResourceHolder<ByteBuffer> resultsBufHolder;
        private final ByteBuffer resultsBuf;
        private final int[] aggregatorSizes;
        private final int numBytesPerRecord;
        private final TopNMetricSpecBuilder<int[]> arrayProvider;

        public static Builder builder() {
            return new Builder();
        }

        public PooledTopNParams(DimensionSelector dimSelector, Cursor cursor, int cardinality, ResourceHolder<ByteBuffer> resultsBufHolder, ByteBuffer resultsBuf, int[] aggregatorSizes, int numBytesPerRecord, int numValuesPerPass, TopNMetricSpecBuilder<int[]> arrayProvider) {
            super(dimSelector, cursor, cardinality, numValuesPerPass);
            this.resultsBufHolder = resultsBufHolder;
            this.resultsBuf = resultsBuf;
            this.aggregatorSizes = aggregatorSizes;
            this.numBytesPerRecord = numBytesPerRecord;
            this.arrayProvider = arrayProvider;
        }

        public ResourceHolder<ByteBuffer> getResultsBufHolder() {
            return this.resultsBufHolder;
        }

        public ByteBuffer getResultsBuf() {
            return this.resultsBuf;
        }

        public int[] getAggregatorSizes() {
            return this.aggregatorSizes;
        }

        public int getNumBytesPerRecord() {
            return this.numBytesPerRecord;
        }

        public TopNMetricSpecBuilder<int[]> getArrayProvider() {
            return this.arrayProvider;
        }

        public static class Builder {
            private DimensionSelector dimSelector = null;
            private Cursor cursor = null;
            private int cardinality = 0;
            private ResourceHolder<ByteBuffer> resultsBufHolder = null;
            private ByteBuffer resultsBuf = null;
            private int[] aggregatorSizes = null;
            private int numBytesPerRecord = 0;
            private int numValuesPerPass = 0;
            private TopNMetricSpecBuilder<int[]> arrayProvider = null;

            public Builder withDimSelector(DimensionSelector dimSelector) {
                this.dimSelector = dimSelector;
                return this;
            }

            public Builder withCursor(Cursor cursor) {
                this.cursor = cursor;
                return this;
            }

            public Builder withCardinality(int cardinality) {
                this.cardinality = cardinality;
                return this;
            }

            public Builder withResultsBufHolder(ResourceHolder<ByteBuffer> resultsBufHolder) {
                this.resultsBufHolder = resultsBufHolder;
                return this;
            }

            public Builder withResultsBuf(ByteBuffer resultsBuf) {
                this.resultsBuf = resultsBuf;
                return this;
            }

            public Builder withAggregatorSizes(int[] aggregatorSizes) {
                this.aggregatorSizes = aggregatorSizes;
                return this;
            }

            public Builder withNumBytesPerRecord(int numBytesPerRecord) {
                this.numBytesPerRecord = numBytesPerRecord;
                return this;
            }

            public Builder withNumValuesPerPass(int numValuesPerPass) {
                this.numValuesPerPass = numValuesPerPass;
                return this;
            }

            public Builder withArrayProvider(TopNMetricSpecBuilder<int[]> arrayProvider) {
                this.arrayProvider = arrayProvider;
                return this;
            }

            public PooledTopNParams build() {
                return new PooledTopNParams(this.dimSelector, this.cursor, this.cardinality, this.resultsBufHolder, this.resultsBuf, this.aggregatorSizes, this.numBytesPerRecord, this.numValuesPerPass, this.arrayProvider);
            }
        }
    }
}

