/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.topn.TopNAlgorithmSelector;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNMetricSpecBuilder;
import io.druid.query.topn.TopNNumericResultBuilder;
import io.druid.query.topn.TopNResultBuilder;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;

public class NumericTopNMetricSpec
implements TopNMetricSpec {
    private static final byte CACHE_TYPE_ID = 0;
    private final String metric;

    @JsonCreator
    public NumericTopNMetricSpec(@JsonProperty(value="metric") String metric) {
        this.metric = metric;
    }

    @Override
    public void verifyPreconditions(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        Preconditions.checkNotNull((Object)this.metric, (Object)"metric can't be null");
        Preconditions.checkNotNull(aggregatorSpecs, (Object)"aggregations cannot be null");
        Preconditions.checkArgument((aggregatorSpecs.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least one AggregatorFactory");
        AggregatorFactory aggregator = (AggregatorFactory)Iterables.tryFind(aggregatorSpecs, (Predicate)new Predicate<AggregatorFactory>(){

            public boolean apply(AggregatorFactory input) {
                return input.getName().equals(NumericTopNMetricSpec.this.metric);
            }
        }).orNull();
        PostAggregator postAggregator = (PostAggregator)Iterables.tryFind(postAggregatorSpecs, (Predicate)new Predicate<PostAggregator>(){

            public boolean apply(PostAggregator input) {
                return input.getName().equals(NumericTopNMetricSpec.this.metric);
            }
        }).orNull();
        Preconditions.checkArgument((aggregator != null || postAggregator != null ? 1 : 0) != 0, (String)"Must have an AggregatorFactory or PostAggregator for metric[%s], gave[%s] and [%s]", (Object[])new Object[]{this.metric, aggregatorSpecs, postAggregatorSpecs});
    }

    @JsonProperty
    public String getMetric() {
        return this.metric;
    }

    @Override
    public Comparator getComparator(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        Comparator comp = null;
        for (AggregatorFactory factory : aggregatorSpecs) {
            if (!this.metric.equals(factory.getName())) continue;
            comp = factory.getComparator();
            break;
        }
        for (PostAggregator pf : postAggregatorSpecs) {
            if (!this.metric.equals(pf.getName())) continue;
            comp = pf.getComparator();
            break;
        }
        return comp;
    }

    @Override
    public TopNResultBuilder getResultBuilder(DateTime timestamp, DimensionSpec dimSpec, int threshold, Comparator comparator) {
        return new TopNNumericResultBuilder(timestamp, dimSpec, this.metric, threshold, comparator);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] metricBytes = this.metric.getBytes(Charsets.UTF_8);
        return ByteBuffer.allocate(1 + metricBytes.length).put((byte)0).put(metricBytes).array();
    }

    @Override
    public <T> TopNMetricSpecBuilder<T> configureOptimizer(TopNMetricSpecBuilder<T> builder) {
        return builder;
    }

    @Override
    public void initTopNAlgorithmSelector(TopNAlgorithmSelector selector) {
        selector.setAggregateTopNMetricFirst(true);
    }

    public String toString() {
        return "NumericTopNMetricSpec{metric='" + this.metric + '\'' + '}';
    }
}

