/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.primitives.UnsignedBytes;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.topn.TopNAlgorithmSelector;
import io.druid.query.topn.TopNLexicographicResultBuilder;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNMetricSpecBuilder;
import io.druid.query.topn.TopNResultBuilder;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;

public class LexicographicTopNMetricSpec
implements TopNMetricSpec {
    private static final byte CACHE_TYPE_ID = 1;
    private static Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String s, String s2) {
            return UnsignedBytes.lexicographicalComparator().compare(s.getBytes(Charsets.UTF_8), s2.getBytes(Charsets.UTF_8));
        }
    };
    private final String previousStop;

    @JsonCreator
    public LexicographicTopNMetricSpec(@JsonProperty(value="previousStop") String previousStop) {
        this.previousStop = previousStop == null ? "" : previousStop;
    }

    @Override
    public void verifyPreconditions(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
    }

    @JsonProperty
    public String getPreviousStop() {
        return this.previousStop;
    }

    @Override
    public Comparator getComparator(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        return comparator;
    }

    @Override
    public TopNResultBuilder getResultBuilder(DateTime timestamp, DimensionSpec dimSpec, int threshold, Comparator comparator) {
        return new TopNLexicographicResultBuilder(timestamp, dimSpec, threshold, this.previousStop, comparator);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] previousStopBytes = this.previousStop.getBytes(Charsets.UTF_8);
        return ByteBuffer.allocate(1 + previousStopBytes.length).put((byte)1).put(previousStopBytes).array();
    }

    @Override
    public <T> TopNMetricSpecBuilder<T> configureOptimizer(TopNMetricSpecBuilder<T> builder) {
        builder.skipTo(this.previousStop);
        builder.ignoreAfterThreshold();
        return builder;
    }

    @Override
    public void initTopNAlgorithmSelector(TopNAlgorithmSelector selector) {
        selector.setAggregateAllMetrics(true);
    }

    public String toString() {
        return "LexicographicTopNMetricSpec{previousStop='" + this.previousStop + '\'' + '}';
    }
}

