/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.common.guava.Comparators;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.topn.TopNAlgorithmSelector;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNMetricSpecBuilder;
import io.druid.query.topn.TopNResultBuilder;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;

public class InvertedTopNMetricSpec
implements TopNMetricSpec {
    private static final byte CACHE_TYPE_ID = 3;
    private final TopNMetricSpec delegate;

    @JsonCreator
    public InvertedTopNMetricSpec(@JsonProperty(value="metric") TopNMetricSpec delegate) {
        this.delegate = delegate;
    }

    @Override
    public void verifyPreconditions(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        this.delegate.verifyPreconditions(aggregatorSpecs, postAggregatorSpecs);
    }

    @JsonProperty(value="metric")
    public TopNMetricSpec getDelegate() {
        return this.delegate;
    }

    @Override
    public Comparator getComparator(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        return Comparators.inverse((Comparator)this.delegate.getComparator(aggregatorSpecs, postAggregatorSpecs));
    }

    @Override
    public TopNResultBuilder getResultBuilder(DateTime timestamp, DimensionSpec dimSpec, int threshold, Comparator comparator) {
        return this.delegate.getResultBuilder(timestamp, dimSpec, threshold, comparator);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] cacheKey = this.delegate.getCacheKey();
        return ByteBuffer.allocate(1 + cacheKey.length).put((byte)3).put(cacheKey).array();
    }

    @Override
    public <T> TopNMetricSpecBuilder<T> configureOptimizer(TopNMetricSpecBuilder<T> builder) {
        return this.delegate.configureOptimizer(builder);
    }

    @Override
    public void initTopNAlgorithmSelector(TopNAlgorithmSelector selector) {
        this.delegate.initTopNAlgorithmSelector(selector);
    }
}

