/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.collect.Lists;
import com.metamx.common.ISE;
import io.druid.collections.StupidPool;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.topn.DimValHolder;
import io.druid.query.topn.NumericTopNMetricSpec;
import io.druid.query.topn.PooledTopNAlgorithm;
import io.druid.query.topn.TopNAlgorithm;
import io.druid.query.topn.TopNParams;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.query.topn.TopNResultBuilder;
import io.druid.segment.Capabilities;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public class AggregateTopNMetricFirstAlgorithm
implements TopNAlgorithm<int[], TopNParams> {
    private final Capabilities capabilities;
    private final TopNQuery query;
    private final Comparator<?> comparator;
    private final StupidPool<ByteBuffer> bufferPool;

    public AggregateTopNMetricFirstAlgorithm(Capabilities capabilities, TopNQuery query, StupidPool<ByteBuffer> bufferPool) {
        this.capabilities = capabilities;
        this.query = query;
        this.comparator = query.getTopNMetricSpec().getComparator(query.getAggregatorSpecs(), query.getPostAggregatorSpecs());
        this.bufferPool = bufferPool;
    }

    @Override
    public TopNParams makeInitParams(DimensionSelector dimSelector, Cursor cursor) {
        return new TopNParams(dimSelector, cursor, dimSelector.getValueCardinality(), Integer.MAX_VALUE);
    }

    @Override
    public TopNResultBuilder makeResultBuilder(TopNParams params) {
        return this.query.getTopNMetricSpec().getResultBuilder(params.getCursor().getTime(), this.query.getDimensionSpec(), this.query.getThreshold(), this.comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TopNParams params, TopNResultBuilder resultBuilder, int[] ints) {
        TopNResultBuilder singleMetricResultBuilder = this.makeResultBuilder(params);
        String metric = ((NumericTopNMetricSpec)this.query.getTopNMetricSpec()).getMetric();
        ArrayList condensedAggs = Lists.newArrayList();
        for (AggregatorFactory aggregatorSpec : this.query.getAggregatorSpecs()) {
            if (!aggregatorSpec.getName().equalsIgnoreCase(metric)) continue;
            condensedAggs.add(aggregatorSpec);
            break;
        }
        ArrayList condensedPostAggs = Lists.newArrayList();
        if (condensedAggs.isEmpty()) {
            for (PostAggregator postAggregator : this.query.getPostAggregatorSpecs()) {
                if (!postAggregator.getName().equalsIgnoreCase(metric)) continue;
                condensedPostAggs.add(postAggregator);
                for (AggregatorFactory aggregatorSpec : this.query.getAggregatorSpecs()) {
                    if (!postAggregator.getDependentFields().contains(aggregatorSpec.getName())) continue;
                    condensedAggs.add(aggregatorSpec);
                }
            }
        }
        if (condensedAggs.isEmpty() && condensedPostAggs.isEmpty()) {
            throw new ISE("WTF! Can't find the metric to do topN over?", new Object[0]);
        }
        TopNQuery singleMetricQuery = new TopNQueryBuilder().copy(this.query).aggregators(condensedAggs).postAggregators(condensedPostAggs).build();
        PooledTopNAlgorithm singleMetricAlgo = new PooledTopNAlgorithm(this.capabilities, singleMetricQuery, this.bufferPool);
        PooledTopNAlgorithm.PooledTopNParams singleMetricParam = null;
        int[] dimValSelector = null;
        try {
            singleMetricParam = singleMetricAlgo.makeInitParams(params.getDimSelector(), params.getCursor());
            singleMetricAlgo.run(singleMetricParam, singleMetricResultBuilder, null);
            dimValSelector = this.getDimValSelectorForTopNMetric(singleMetricParam, singleMetricResultBuilder);
        }
        finally {
            if (singleMetricParam != null) {
                singleMetricAlgo.cleanup(singleMetricParam);
            }
        }
        PooledTopNAlgorithm allMetricAlgo = new PooledTopNAlgorithm(this.capabilities, this.query, this.bufferPool);
        PooledTopNAlgorithm.PooledTopNParams allMetricsParam = null;
        try {
            allMetricsParam = allMetricAlgo.makeInitParams(params.getDimSelector(), params.getCursor());
            allMetricAlgo.run(allMetricsParam, resultBuilder, dimValSelector);
        }
        finally {
            if (allMetricsParam != null) {
                allMetricAlgo.cleanup(allMetricsParam);
            }
        }
    }

    @Override
    public void cleanup(TopNParams params) {
    }

    private int[] getDimValSelectorForTopNMetric(TopNParams params, TopNResultBuilder resultBuilder) {
        int[] dimValSelector = new int[params.getDimSelector().getValueCardinality()];
        Arrays.fill(dimValSelector, -2);
        Iterator<DimValHolder> dimValIter = resultBuilder.getTopNIterator();
        while (dimValIter.hasNext()) {
            int dimValIndex = (Integer)dimValIter.next().getDimValIndex();
            dimValSelector[dimValIndex] = -1;
        }
        return dimValSelector;
    }
}

