/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.metamx.common.guava.MergeSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.OrderedMergeSequence;
import io.druid.granularity.QueryGranularity;
import io.druid.query.CacheStrategy;
import io.druid.query.IntervalChunkingQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryCacheHelper;
import io.druid.query.QueryConfig;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.ResultGranularTimestampComparator;
import io.druid.query.ResultMergeQueryRunner;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.filter.DimFilter;
import io.druid.query.timeseries.TimeseriesBinaryFn;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesResultValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Minutes;
import org.joda.time.ReadableInterval;

public class TimeseriesQueryQueryToolChest
extends QueryToolChest<Result<TimeseriesResultValue>, TimeseriesQuery> {
    private static final byte TIMESERIES_QUERY = 0;
    private static final Joiner COMMA_JOIN = Joiner.on((String)",");
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Result<TimeseriesResultValue>> TYPE_REFERENCE = new TypeReference<Result<TimeseriesResultValue>>(){};
    private final QueryConfig config;

    @Inject
    public TimeseriesQueryQueryToolChest(QueryConfig config) {
        this.config = config;
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> mergeResults(QueryRunner<Result<TimeseriesResultValue>> queryRunner) {
        return new ResultMergeQueryRunner<Result<TimeseriesResultValue>>(queryRunner){

            @Override
            protected Ordering<Result<TimeseriesResultValue>> makeOrdering(Query<Result<TimeseriesResultValue>> query) {
                return Ordering.from(new ResultGranularTimestampComparator(((TimeseriesQuery)query).getGranularity()));
            }

            @Override
            protected BinaryFn<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> createMergeFn(Query<Result<TimeseriesResultValue>> input) {
                TimeseriesQuery query = (TimeseriesQuery)input;
                return new TimeseriesBinaryFn(query.getGranularity(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs());
            }
        };
    }

    @Override
    public Sequence<Result<TimeseriesResultValue>> mergeSequences(Sequence<Sequence<Result<TimeseriesResultValue>>> seqOfSequences) {
        return new OrderedMergeSequence(this.getOrdering(), seqOfSequences);
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(TimeseriesQuery query) {
        int numMinutes = 0;
        for (Interval interval : query.getIntervals()) {
            numMinutes += Minutes.minutesIn((ReadableInterval)interval).getMinutes();
        }
        return new ServiceMetricEvent.Builder().setUser2(query.getDataSource()).setUser4("timeseries").setUser5(COMMA_JOIN.join(query.getIntervals())).setUser6(String.valueOf(query.hasFilters())).setUser7(String.format("%,d aggs", query.getAggregatorSpecs().size())).setUser9(Minutes.minutes((int)numMinutes).toString());
    }

    @Override
    public Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> makeMetricManipulatorFn(final TimeseriesQuery query, final MetricManipulationFn fn) {
        return new Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>>(){

            public Result<TimeseriesResultValue> apply(Result<TimeseriesResultValue> result) {
                HashMap values = Maps.newHashMap();
                TimeseriesResultValue holder = result.getValue();
                for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                    values.put(agg.getName(), fn.manipulate(agg, holder.getMetric(agg.getName())));
                }
                for (PostAggregator postAgg : query.getPostAggregatorSpecs()) {
                    values.put(postAgg.getName(), holder.getMetric(postAgg.getName()));
                }
                return new Result<TimeseriesResultValue>(result.getTimestamp(), new TimeseriesResultValue(values));
            }
        };
    }

    @Override
    public TypeReference<Result<TimeseriesResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TimeseriesResultValue>, Object, TimeseriesQuery> getCacheStrategy(final TimeseriesQuery query) {
        return new CacheStrategy<Result<TimeseriesResultValue>, Object, TimeseriesQuery>(){
            private final List<AggregatorFactory> aggs;
            private final List<PostAggregator> postAggs;
            {
                this.aggs = query.getAggregatorSpecs();
                this.postAggs = query.getPostAggregatorSpecs();
            }

            @Override
            public byte[] computeCacheKey(TimeseriesQuery query2) {
                DimFilter dimFilter = query2.getDimensionsFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] aggregatorBytes = QueryCacheHelper.computeAggregatorBytes(query2.getAggregatorSpecs());
                byte[] granularityBytes = query2.getGranularity().cacheKey();
                return ByteBuffer.allocate(1 + granularityBytes.length + filterBytes.length + aggregatorBytes.length).put((byte)0).put(granularityBytes).put(filterBytes).put(aggregatorBytes).array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TimeseriesResultValue>, Object> prepareForCache() {
                return new Function<Result<TimeseriesResultValue>, Object>(){

                    public Object apply(@Nullable Result<TimeseriesResultValue> input) {
                        TimeseriesResultValue results = input.getValue();
                        ArrayList retVal = Lists.newArrayListWithCapacity((int)(1 + aggs.size()));
                        retVal.add(input.getTimestamp().getMillis());
                        for (AggregatorFactory agg : aggs) {
                            retVal.add(results.getMetric(agg.getName()));
                        }
                        return retVal;
                    }
                };
            }

            @Override
            public Function<Object, Result<TimeseriesResultValue>> pullFromCache() {
                return new Function<Object, Result<TimeseriesResultValue>>(){
                    private final QueryGranularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Result<TimeseriesResultValue> apply(@Nullable Object input) {
                        List results = (List)input;
                        LinkedHashMap retVal = Maps.newLinkedHashMap();
                        Iterator aggsIter = aggs.iterator();
                        Iterator resultIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)resultIter.next()).longValue());
                        while (aggsIter.hasNext() && resultIter.hasNext()) {
                            AggregatorFactory factory = (AggregatorFactory)aggsIter.next();
                            retVal.put(factory.getName(), factory.deserialize(resultIter.next()));
                        }
                        for (PostAggregator postAgg : postAggs) {
                            retVal.put(postAgg.getName(), postAgg.compute(retVal));
                        }
                        return new Result<TimeseriesResultValue>(timestamp, new TimeseriesResultValue(retVal));
                    }
                };
            }

            @Override
            public Sequence<Result<TimeseriesResultValue>> mergeSequences(Sequence<Sequence<Result<TimeseriesResultValue>>> seqOfSequences) {
                return new MergeSequence(TimeseriesQueryQueryToolChest.this.getOrdering(), seqOfSequences);
            }
        };
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> preMergeQueryDecoration(QueryRunner<Result<TimeseriesResultValue>> runner) {
        return new IntervalChunkingQueryRunner<Result<TimeseriesResultValue>>(runner, this.config.getChunkPeriod());
    }

    public Ordering<Result<TimeseriesResultValue>> getOrdering() {
        return Ordering.natural();
    }
}

