/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.google.common.base.Function;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.Sequence;
import io.druid.query.QueryRunnerHelper;
import io.druid.query.Result;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesResultBuilder;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.Cursor;
import io.druid.segment.StorageAdapter;
import io.druid.segment.filter.Filters;
import java.util.Iterator;
import java.util.List;

public class TimeseriesQueryEngine {
    public Sequence<Result<TimeseriesResultValue>> process(final TimeseriesQuery query, final StorageAdapter adapter) {
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Result<TimeseriesResultValue>, Iterator<Result<TimeseriesResultValue>>>(){

            public Iterator<Result<TimeseriesResultValue>> make() {
                return QueryRunnerHelper.makeCursorBasedQuery(adapter, query.getQuerySegmentSpec().getIntervals(), Filters.convertDimensionFilters(query.getDimensionsFilter()), query.getGranularity(), new Function<Cursor, Result<TimeseriesResultValue>>(){
                    private final List<AggregatorFactory> aggregatorSpecs;
                    private final List<PostAggregator> postAggregatorSpecs;
                    {
                        this.aggregatorSpecs = query.getAggregatorSpecs();
                        this.postAggregatorSpecs = query.getPostAggregatorSpecs();
                    }

                    public Result<TimeseriesResultValue> apply(Cursor cursor) {
                        Aggregator[] aggregators = QueryRunnerHelper.makeAggregators(cursor, this.aggregatorSpecs);
                        while (!cursor.isDone()) {
                            for (Aggregator aggregator : aggregators) {
                                aggregator.aggregate();
                            }
                            cursor.advance();
                        }
                        TimeseriesResultBuilder bob = new TimeseriesResultBuilder(cursor.getTime());
                        for (Aggregator aggregator : aggregators) {
                            bob.addMetric(aggregator);
                        }
                        for (PostAggregator postAgg : this.postAggregatorSpecs) {
                            bob.addMetric(postAgg);
                        }
                        Result<TimeseriesResultValue> retVal = bob.build();
                        for (Aggregator agg : aggregators) {
                            agg.close();
                        }
                        return retVal;
                    }
                }).iterator();
            }

            public void cleanup(Iterator<Result<TimeseriesResultValue>> toClean) {
                while (toClean.hasNext()) {
                    toClean.next();
                }
            }
        });
    }
}

