/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableList;
import io.druid.granularity.QueryGranularity;
import io.druid.query.BaseQuery;
import io.druid.query.Queries;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.filter.DimFilter;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeseries.TimeseriesResultValue;
import java.util.List;
import java.util.Map;

@JsonTypeName(value="timeseries")
public class TimeseriesQuery
extends BaseQuery<Result<TimeseriesResultValue>> {
    private final DimFilter dimFilter;
    private final QueryGranularity granularity;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;

    @JsonCreator
    public TimeseriesQuery(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") QueryGranularity granularity, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="context") Map<String, String> context) {
        super(dataSource, querySegmentSpec, context);
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.aggregatorSpecs = aggregatorSpecs;
        this.postAggregatorSpecs = postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs;
        Queries.verifyAggregations(this.aggregatorSpecs, this.postAggregatorSpecs);
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public String getType() {
        return "timeseries";
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="postAggregations")
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    public TimeseriesQuery withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return new TimeseriesQuery(this.getDataSource(), querySegmentSpec, this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.getContext());
    }

    public TimeseriesQuery withOverriddenContext(Map<String, String> contextOverrides) {
        return new TimeseriesQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.computeOverridenContext(contextOverrides));
    }

    public String toString() {
        return "TimeseriesQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", dimFilter=" + this.dimFilter + ", granularity='" + this.granularity + '\'' + ", aggregatorSpecs=" + this.aggregatorSpecs + ", postAggregatorSpecs=" + this.postAggregatorSpecs + ", context=" + this.getContext() + '}';
    }
}

