/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeboundary;

import com.metamx.common.ISE;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.Sequence;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryQueryQueryToolChest;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;

public class TimeBoundaryQueryRunnerFactory
implements QueryRunnerFactory<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> {
    private static final TimeBoundaryQueryQueryToolChest toolChest = new TimeBoundaryQueryQueryToolChest();

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> createRunner(Segment segment) {
        return new TimeBoundaryQueryRunner(segment);
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<TimeBoundaryResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TimeBoundaryResultValue>>(queryExecutor, toolChest.getOrdering(), queryRunners);
    }

    @Override
    public QueryToolChest<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> getToolchest() {
        return toolChest;
    }

    private static class TimeBoundaryQueryRunner
    implements QueryRunner<Result<TimeBoundaryResultValue>> {
        private final StorageAdapter adapter;

        public TimeBoundaryQueryRunner(Segment segment) {
            this.adapter = segment.asStorageAdapter();
        }

        @Override
        public Sequence<Result<TimeBoundaryResultValue>> run(Query<Result<TimeBoundaryResultValue>> input) {
            if (!(input instanceof TimeBoundaryQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), TimeBoundaryQuery.class});
            }
            final TimeBoundaryQuery legacyQuery = (TimeBoundaryQuery)input;
            return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Result<TimeBoundaryResultValue>, Iterator<Result<TimeBoundaryResultValue>>>(){

                public Iterator<Result<TimeBoundaryResultValue>> make() {
                    return legacyQuery.buildResult(TimeBoundaryQueryRunner.this.adapter.getInterval().getStart(), TimeBoundaryQueryRunner.this.adapter.getMinTime(), TimeBoundaryQueryRunner.this.adapter.getMaxTime()).iterator();
                }

                public void cleanup(Iterator<Result<TimeBoundaryResultValue>> toClean) {
                }
            });
        }
    }
}

