/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeboundary;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.query.BaseQuery;
import io.druid.query.Result;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class TimeBoundaryQuery
extends BaseQuery<Result<TimeBoundaryResultValue>> {
    public static final Interval MY_Y2K_INTERVAL = new Interval((ReadableInstant)new DateTime((Object)"0000-01-01"), (ReadableInstant)new DateTime((Object)"3000-01-01"));
    public static final String MAX_TIME = "maxTime";
    public static final String MIN_TIME = "minTime";
    private static final byte CACHE_TYPE_ID = 0;

    @JsonCreator
    public TimeBoundaryQuery(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="context") Map<String, String> context) {
        super(dataSource, querySegmentSpec == null ? new MultipleIntervalSegmentSpec(Arrays.asList(MY_Y2K_INTERVAL)) : querySegmentSpec, context);
    }

    @Override
    public boolean hasFilters() {
        return false;
    }

    @Override
    public String getType() {
        return "timeBoundary";
    }

    public TimeBoundaryQuery withOverriddenContext(Map<String, String> contextOverrides) {
        return new TimeBoundaryQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.computeOverridenContext(contextOverrides));
    }

    public TimeBoundaryQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new TimeBoundaryQuery(this.getDataSource(), spec, this.getContext());
    }

    public byte[] getCacheKey() {
        return ByteBuffer.allocate(1).put((byte)0).array();
    }

    public String toString() {
        return "TimeBoundaryQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", duration=" + this.getDuration() + '}';
    }

    public Iterable<Result<TimeBoundaryResultValue>> buildResult(DateTime timestamp, DateTime min, DateTime max) {
        ArrayList results = Lists.newArrayList();
        HashMap result = Maps.newHashMap();
        if (min != null) {
            result.put(MIN_TIME, min);
        }
        if (max != null) {
            result.put(MAX_TIME, max);
        }
        if (!result.isEmpty()) {
            results.add(new Result<TimeBoundaryResultValue>(timestamp, new TimeBoundaryResultValue(result)));
        }
        return results;
    }

    public Iterable<Result<TimeBoundaryResultValue>> mergeResults(List<Result<TimeBoundaryResultValue>> results) {
        if (results == null || results.isEmpty()) {
            return Lists.newArrayList();
        }
        DateTime min = new DateTime(Long.MAX_VALUE);
        DateTime max = new DateTime(Long.MIN_VALUE);
        for (Result<TimeBoundaryResultValue> result : results) {
            DateTime currMaxTime;
            TimeBoundaryResultValue val = result.getValue();
            DateTime currMinTime = val.getMinTime();
            if (currMinTime.isBefore((ReadableInstant)min)) {
                min = currMinTime;
            }
            if (!(currMaxTime = val.getMaxTime()).isAfter((ReadableInstant)max)) continue;
            max = currMaxTime;
        }
        return Arrays.asList(new Result<TimeBoundaryResultValue>(min, new TimeBoundaryResultValue(ImmutableMap.of((Object)MIN_TIME, (Object)min, (Object)MAX_TIME, (Object)max))));
    }
}

