/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.guava.MergeSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.OrderedMergeSequence;
import io.druid.granularity.QueryGranularity;
import io.druid.query.CacheStrategy;
import io.druid.query.IntervalChunkingQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryConfig;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.ResultGranularTimestampComparator;
import io.druid.query.ResultMergeQueryRunner;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.select.EventHolder;
import io.druid.query.select.SelectBinaryFn;
import io.druid.query.select.SelectQuery;
import io.druid.query.select.SelectResultValue;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Minutes;
import org.joda.time.ReadableInterval;

public class SelectQueryQueryToolChest
extends QueryToolChest<Result<SelectResultValue>, SelectQuery> {
    private static final byte SELECT_QUERY = 19;
    private static final Joiner COMMA_JOIN = Joiner.on((String)",");
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Result<SelectResultValue>> TYPE_REFERENCE = new TypeReference<Result<SelectResultValue>>(){};
    private final QueryConfig config;
    private final ObjectMapper jsonMapper;

    @Inject
    public SelectQueryQueryToolChest(QueryConfig config, ObjectMapper jsonMapper) {
        this.config = config;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> mergeResults(QueryRunner<Result<SelectResultValue>> queryRunner) {
        return new ResultMergeQueryRunner<Result<SelectResultValue>>(queryRunner){

            @Override
            protected Ordering<Result<SelectResultValue>> makeOrdering(Query<Result<SelectResultValue>> query) {
                return Ordering.from(new ResultGranularTimestampComparator(((SelectQuery)query).getGranularity()));
            }

            @Override
            protected BinaryFn<Result<SelectResultValue>, Result<SelectResultValue>, Result<SelectResultValue>> createMergeFn(Query<Result<SelectResultValue>> input) {
                SelectQuery query = (SelectQuery)input;
                return new SelectBinaryFn(query.getGranularity(), query.getPagingSpec());
            }
        };
    }

    @Override
    public Sequence<Result<SelectResultValue>> mergeSequences(Sequence<Sequence<Result<SelectResultValue>>> seqOfSequences) {
        return new OrderedMergeSequence(this.getOrdering(), seqOfSequences);
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(SelectQuery query) {
        int numMinutes = 0;
        for (Interval interval : query.getIntervals()) {
            numMinutes += Minutes.minutesIn((ReadableInterval)interval).getMinutes();
        }
        return new ServiceMetricEvent.Builder().setUser2(query.getDataSource()).setUser4("Select").setUser5(COMMA_JOIN.join(query.getIntervals())).setUser6(String.valueOf(query.hasFilters())).setUser9(Minutes.minutes((int)numMinutes).toString());
    }

    @Override
    public Function<Result<SelectResultValue>, Result<SelectResultValue>> makeMetricManipulatorFn(SelectQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<SelectResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<SelectResultValue>, Object, SelectQuery> getCacheStrategy(final SelectQuery query) {
        return new CacheStrategy<Result<SelectResultValue>, Object, SelectQuery>(){

            @Override
            public byte[] computeCacheKey(SelectQuery query2) {
                DimFilter dimFilter = query2.getDimensionsFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] granularityBytes = query2.getGranularity().cacheKey();
                TreeSet dimensions = Sets.newTreeSet();
                if (query2.getDimensions() != null) {
                    dimensions.addAll(query2.getDimensions());
                }
                byte[][] dimensionsBytes = new byte[dimensions.size()][];
                int dimensionsBytesSize = 0;
                int index = 0;
                for (String dimension : dimensions) {
                    dimensionsBytes[index] = dimension.getBytes();
                    dimensionsBytesSize += dimensionsBytes[index].length;
                    ++index;
                }
                TreeSet metrics = Sets.newTreeSet();
                if (query2.getMetrics() != null) {
                    dimensions.addAll(query2.getMetrics());
                }
                byte[][] metricBytes = new byte[metrics.size()][];
                int metricBytesSize = 0;
                index = 0;
                for (String metric : metrics) {
                    metricBytes[index] = metric.getBytes();
                    metricBytesSize += metricBytes[index].length;
                    ++index;
                }
                ByteBuffer queryCacheKey = ByteBuffer.allocate(1 + granularityBytes.length + filterBytes.length + query2.getPagingSpec().getCacheKey().length + dimensionsBytesSize + metricBytesSize).put((byte)19).put(granularityBytes).put(filterBytes).put(query2.getPagingSpec().getCacheKey());
                for (byte[] dimensionsByte : dimensionsBytes) {
                    queryCacheKey.put(dimensionsByte);
                }
                for (byte[] metricByte : metricBytes) {
                    queryCacheKey.put(metricByte);
                }
                return queryCacheKey.array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<SelectResultValue>, Object> prepareForCache() {
                return new Function<Result<SelectResultValue>, Object>(){

                    public Object apply(Result<SelectResultValue> input) {
                        return Arrays.asList(input.getTimestamp().getMillis(), input.getValue().getPagingIdentifiers(), input.getValue().getEvents());
                    }
                };
            }

            @Override
            public Function<Object, Result<SelectResultValue>> pullFromCache() {
                return new Function<Object, Result<SelectResultValue>>(){
                    private final QueryGranularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Result<SelectResultValue> apply(Object input) {
                        List results = (List)input;
                        Iterator resultIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)resultIter.next()).longValue());
                        return new Result<SelectResultValue>(timestamp, new SelectResultValue((Map)SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), (TypeReference)new TypeReference<Map<String, Integer>>(){}), (List)SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), (TypeReference)new TypeReference<List<EventHolder>>(){})));
                    }
                };
            }

            @Override
            public Sequence<Result<SelectResultValue>> mergeSequences(Sequence<Sequence<Result<SelectResultValue>>> seqOfSequences) {
                return new MergeSequence(SelectQueryQueryToolChest.this.getOrdering(), seqOfSequences);
            }
        };
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> preMergeQueryDecoration(QueryRunner<Result<SelectResultValue>> runner) {
        return new IntervalChunkingQueryRunner<Result<SelectResultValue>>(runner, this.config.getChunkPeriod());
    }

    public Ordering<Result<SelectResultValue>> getOrdering() {
        return Ordering.natural();
    }
}

