/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.Sequence;
import io.druid.query.QueryRunnerHelper;
import io.druid.query.Result;
import io.druid.query.select.EventHolder;
import io.druid.query.select.SelectQuery;
import io.druid.query.select.SelectResultValue;
import io.druid.query.select.SelectResultValueBuilder;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import io.druid.segment.TimestampColumnSelector;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.Filters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.time.DateTime;

public class SelectQueryEngine {
    public Sequence<Result<SelectResultValue>> process(final SelectQuery query, final Segment segment) {
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Result<SelectResultValue>, Iterator<Result<SelectResultValue>>>(){

            public Iterator<Result<SelectResultValue>> make() {
                StorageAdapter adapter = segment.asStorageAdapter();
                final Iterable<String> dims = query.getDimensions() == null || query.getDimensions().isEmpty() ? adapter.getAvailableDimensions() : query.getDimensions();
                final Iterable<String> metrics = query.getMetrics() == null || query.getMetrics().isEmpty() ? adapter.getAvailableMetrics() : query.getMetrics();
                return QueryRunnerHelper.makeCursorBasedQuery(adapter, query.getQuerySegmentSpec().getIntervals(), Filters.convertDimensionFilters(query.getDimensionsFilter()), query.getGranularity(), new Function<Cursor, Result<SelectResultValue>>(){

                    public Result<SelectResultValue> apply(Cursor cursor) {
                        Integer offset;
                        SelectResultValueBuilder builder = new SelectResultValueBuilder(cursor.getTime(), query.getPagingSpec().getThreshold());
                        TimestampColumnSelector timestampColumnSelector = cursor.makeTimestampColumnSelector();
                        HashMap dimSelectors = Maps.newHashMap();
                        for (String dim : dims) {
                            DimensionSelector dimSelector = cursor.makeDimensionSelector(dim);
                            dimSelectors.put(dim, dimSelector);
                        }
                        HashMap metSelectors = Maps.newHashMap();
                        for (String metric : metrics) {
                            ObjectColumnSelector metricSelector = cursor.makeObjectColumnSelector(metric);
                            metSelectors.put(metric, metricSelector);
                        }
                        int startOffset = query.getPagingSpec().getPagingIdentifiers() == null ? 0 : ((offset = query.getPagingSpec().getPagingIdentifiers().get(segment.getIdentifier())) == null ? 0 : offset);
                        cursor.advanceTo(startOffset);
                        for (int offset2 = 0; !cursor.isDone() && offset2 < query.getPagingSpec().getThreshold(); ++offset2) {
                            Object selector;
                            LinkedHashMap theEvent = Maps.newLinkedHashMap();
                            theEvent.put("timestamp", new DateTime(timestampColumnSelector.getTimestamp()));
                            for (Map.Entry dimSelector : dimSelectors.entrySet()) {
                                String dim = (String)dimSelector.getKey();
                                selector = (DimensionSelector)dimSelector.getValue();
                                IndexedInts vals = selector.getRow();
                                if (vals.size() == 1) {
                                    String dimVal = selector.lookupName(vals.get(0));
                                    theEvent.put(dim, dimVal);
                                    continue;
                                }
                                ArrayList dimVals = Lists.newArrayList();
                                for (int i = 0; i < vals.size(); ++i) {
                                    dimVals.add(selector.lookupName(vals.get(i)));
                                }
                                theEvent.put(dim, dimVals);
                            }
                            for (Map.Entry metSelector : metSelectors.entrySet()) {
                                String metric = (String)metSelector.getKey();
                                selector = (ObjectColumnSelector)metSelector.getValue();
                                theEvent.put(metric, selector.get());
                            }
                            builder.addEntry(new EventHolder(segment.getIdentifier(), startOffset + offset2, theEvent));
                            cursor.advance();
                        }
                        return builder.build();
                    }
                }).iterator();
            }

            public void cleanup(Iterator<Result<SelectResultValue>> toClean) {
                while (toClean.hasNext()) {
                    toClean.next();
                }
            }
        });
    }
}

