/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.druid.granularity.QueryGranularity;
import io.druid.query.BaseQuery;
import io.druid.query.Result;
import io.druid.query.filter.DimFilter;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectResultValue;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.List;
import java.util.Map;

@JsonTypeName(value="select")
public class SelectQuery
extends BaseQuery<Result<SelectResultValue>> {
    private final DimFilter dimFilter;
    private final QueryGranularity granularity;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final PagingSpec pagingSpec;

    @JsonCreator
    public SelectQuery(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") QueryGranularity granularity, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="metrics") List<String> metrics, @JsonProperty(value="pagingSpec") PagingSpec pagingSpec, @JsonProperty(value="context") Map<String, String> context) {
        super(dataSource, querySegmentSpec, context);
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.pagingSpec = pagingSpec;
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public String getType() {
        return "select";
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public PagingSpec getPagingSpec() {
        return this.pagingSpec;
    }

    @JsonProperty
    public List<String> getMetrics() {
        return this.metrics;
    }

    public SelectQuery withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return new SelectQuery(this.getDataSource(), querySegmentSpec, this.dimFilter, this.granularity, this.dimensions, this.metrics, this.pagingSpec, this.getContext());
    }

    public SelectQuery withOverriddenContext(Map<String, String> contextOverrides) {
        return new SelectQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.dimensions, this.metrics, this.pagingSpec, this.computeOverridenContext(contextOverrides));
    }

    public String toString() {
        return "SelectQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", dimFilter=" + this.dimFilter + ", granularity=" + this.granularity + ", dimensions=" + this.dimensions + ", metrics=" + this.metrics + ", pagingSpec=" + this.pagingSpec + '}';
    }
}

