/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.druid.granularity.QueryGranularity;
import io.druid.query.BaseQuery;
import io.druid.query.Result;
import io.druid.query.filter.DimFilter;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.LexicographicSearchSortSpec;
import io.druid.query.search.search.SearchQuerySpec;
import io.druid.query.search.search.SearchSortSpec;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class SearchQuery
extends BaseQuery<Result<SearchResultValue>> {
    private final DimFilter dimFilter;
    private final SearchSortSpec sortSpec;
    private final QueryGranularity granularity;
    private final List<String> dimensions;
    private final SearchQuerySpec querySpec;
    private final int limit;

    @JsonCreator
    public SearchQuery(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") QueryGranularity granularity, @JsonProperty(value="limit") int limit, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="searchDimensions") List<String> dimensions, @JsonProperty(value="query") SearchQuerySpec querySpec, @JsonProperty(value="sort") SearchSortSpec sortSpec, @JsonProperty(value="context") Map<String, String> context) {
        super(dataSource, querySegmentSpec, context);
        this.dimFilter = dimFilter;
        this.sortSpec = sortSpec == null ? new LexicographicSearchSortSpec() : sortSpec;
        this.granularity = granularity == null ? QueryGranularity.ALL : granularity;
        this.limit = limit == 0 ? 1000 : limit;
        this.dimensions = dimensions == null ? null : Lists.transform(dimensions, (Function)new Function<String, String>(){

            public String apply(@Nullable String input) {
                return input;
            }
        });
        this.querySpec = querySpec;
        Preconditions.checkNotNull((Object)querySegmentSpec, (Object)"Must specify an interval");
        Preconditions.checkNotNull((Object)querySpec, (Object)"Must specify a query");
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public String getType() {
        return "search";
    }

    public SearchQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new SearchQuery(this.getDataSource(), this.dimFilter, this.granularity, this.limit, spec, this.dimensions, this.querySpec, this.sortSpec, this.getContext());
    }

    public SearchQuery withOverriddenContext(Map<String, String> contextOverrides) {
        return new SearchQuery(this.getDataSource(), this.dimFilter, this.granularity, this.limit, this.getQuerySegmentSpec(), this.dimensions, this.querySpec, this.sortSpec, this.computeOverridenContext(contextOverrides));
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty
    public int getLimit() {
        return this.limit;
    }

    @JsonProperty(value="searchDimensions")
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="query")
    public SearchQuerySpec getQuery() {
        return this.querySpec;
    }

    @JsonProperty(value="sort")
    public SearchSortSpec getSort() {
        return this.sortSpec;
    }

    public SearchQuery withLimit(int newLimit) {
        return new SearchQuery(this.getDataSource(), this.dimFilter, this.granularity, newLimit, this.getQuerySegmentSpec(), this.dimensions, this.querySpec, this.sortSpec, this.getContext());
    }

    public String toString() {
        return "SearchQuery{dataSource='" + this.getDataSource() + '\'' + ", dimFilter=" + this.dimFilter + ", granularity='" + this.granularity + '\'' + ", dimensions=" + this.dimensions + ", querySpec=" + this.querySpec + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", limit=" + this.limit + '}';
    }
}

