/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.query.search.search.SearchQuerySpec;
import java.nio.ByteBuffer;

public class InsensitiveContainsSearchQuerySpec
implements SearchQuerySpec {
    private static final byte CACHE_TYPE_ID = 1;
    private final String value;

    @JsonCreator
    public InsensitiveContainsSearchQuerySpec(@JsonProperty(value="value") String value) {
        this.value = value.toLowerCase();
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean accept(String dimVal) {
        if (dimVal == null) {
            return false;
        }
        return dimVal.toLowerCase().contains(this.value);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] valueBytes = this.value.getBytes();
        return ByteBuffer.allocate(1 + valueBytes.length).put((byte)1).put(valueBytes).array();
    }

    public String toString() {
        return "InsensitiveContainsSearchQuerySpec{value=" + this.value + "}";
    }
}

