/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.metamx.common.ISE;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.EmittingLogger;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import io.druid.query.filter.Filter;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.SearchHit;
import io.druid.query.search.search.SearchQuery;
import io.druid.query.search.search.SearchQuerySpec;
import io.druid.segment.ColumnSelectorBitmapIndexSelector;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.QueryableIndex;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.Filters;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class SearchQueryRunner
implements QueryRunner<Result<SearchResultValue>> {
    private static final EmittingLogger log = new EmittingLogger(SearchQueryRunner.class);
    private final Segment segment;

    public SearchQueryRunner(Segment segment) {
        this.segment = segment;
    }

    @Override
    public Sequence<Result<SearchResultValue>> run(Query<Result<SearchResultValue>> input) {
        if (!(input instanceof SearchQuery)) {
            throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), SearchQuery.class});
        }
        SearchQuery query = (SearchQuery)input;
        Filter filter = Filters.convertDimensionFilters(query.getDimensionsFilter());
        List<String> dimensions = query.getDimensions();
        SearchQuerySpec searchQuerySpec = query.getQuery();
        int limit = query.getLimit();
        QueryableIndex index = this.segment.asQueryableIndex();
        if (index != null) {
            ImmutableConciseSet baseFilter;
            TreeSet retVal = Sets.newTreeSet(query.getSort().getComparator());
            Iterable<String> dimsToSearch = dimensions == null || dimensions.isEmpty() ? index.getAvailableDimensions() : dimensions;
            if (filter == null) {
                if (index.getNumRows() == 1) {
                    ConciseSet set = new ConciseSet();
                    set.add(0);
                    baseFilter = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
                } else {
                    baseFilter = ImmutableConciseSet.complement((ImmutableConciseSet)new ImmutableConciseSet(), (int)index.getNumRows());
                }
            } else {
                baseFilter = filter.goConcise(new ColumnSelectorBitmapIndexSelector(index));
            }
            for (String dimension : dimsToSearch) {
                BitmapIndex bitmapIndex;
                Column column = index.getColumn(dimension.toLowerCase());
                if (column == null || (bitmapIndex = column.getBitmapIndex()) == null) continue;
                for (int i = 0; i < bitmapIndex.getCardinality(); ++i) {
                    String string = Strings.nullToEmpty((String)bitmapIndex.getValue(i));
                    if (!searchQuerySpec.accept(string) || ImmutableConciseSet.intersection((ImmutableConciseSet[])new ImmutableConciseSet[]{baseFilter, bitmapIndex.getConciseSet(i)}).size() <= 0) continue;
                    retVal.add(new SearchHit(dimension, string));
                    if (retVal.size() < limit) continue;
                    return this.makeReturnResult(limit, retVal);
                }
            }
            return this.makeReturnResult(limit, retVal);
        }
        StorageAdapter adapter = this.segment.asStorageAdapter();
        if (adapter != null) {
            Iterable<String> dimsToSearch = dimensions == null || dimensions.isEmpty() ? adapter.getAvailableDimensions() : dimensions;
            TreeSet retVal = Sets.newTreeSet(query.getSort().getComparator());
            Iterable<Cursor> cursors = adapter.makeCursors(filter, this.segment.getDataInterval(), QueryGranularity.ALL);
            for (Cursor cursor : cursors) {
                HashMap dimSelectors = Maps.newHashMap();
                for (String string : dimsToSearch) {
                    dimSelectors.put(string, cursor.makeDimensionSelector(string));
                }
                while (!cursor.isDone()) {
                    for (Map.Entry entry : dimSelectors.entrySet()) {
                        DimensionSelector selector = (DimensionSelector)entry.getValue();
                        IndexedInts vals = selector.getRow();
                        for (int i = 0; i < vals.size(); ++i) {
                            String dimVal = selector.lookupName(vals.get(i));
                            if (!searchQuerySpec.accept(dimVal)) continue;
                            retVal.add(new SearchHit((String)entry.getKey(), dimVal));
                            if (retVal.size() < limit) continue;
                            return this.makeReturnResult(limit, retVal);
                        }
                    }
                    cursor.advance();
                }
            }
            return this.makeReturnResult(limit, retVal);
        }
        log.makeAlert("WTF!? Unable to process search query on segment.", new Object[0]).addData("segment", (Object)this.segment.getIdentifier()).addData("query", (Object)query);
        return Sequences.empty();
    }

    private Sequence<Result<SearchResultValue>> makeReturnResult(int limit, TreeSet<SearchHit> retVal) {
        return Sequences.simple((Iterable)ImmutableList.of(new Result<SearchResultValue>(this.segment.getDataInterval().getStart(), new SearchResultValue(Lists.newArrayList((Iterable)new FunctionalIterable(retVal).limit(limit))))));
    }
}

