/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.guava.nary.BinaryFn;
import io.druid.granularity.AllGranularity;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.SearchSortSpec;
import java.util.TreeSet;

public class SearchBinaryFn
implements BinaryFn<Result<SearchResultValue>, Result<SearchResultValue>, Result<SearchResultValue>> {
    private final SearchSortSpec searchSortSpec;
    private final QueryGranularity gran;

    public SearchBinaryFn(SearchSortSpec searchSortSpec, QueryGranularity granularity) {
        this.searchSortSpec = searchSortSpec;
        this.gran = granularity;
    }

    public Result<SearchResultValue> apply(Result<SearchResultValue> arg1, Result<SearchResultValue> arg2) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        SearchResultValue arg1Vals = arg1.getValue();
        SearchResultValue arg2Vals = arg2.getValue();
        TreeSet results = Sets.newTreeSet(this.searchSortSpec.getComparator());
        results.addAll(Lists.newArrayList((Iterable)arg1Vals));
        results.addAll(Lists.newArrayList((Iterable)arg2Vals));
        return this.gran instanceof AllGranularity ? new Result<SearchResultValue>(arg1.getTimestamp(), new SearchResultValue(Lists.newArrayList((Iterable)results))) : new Result<SearchResultValue>(this.gran.toDateTime(this.gran.truncate(arg1.getTimestamp().getMillis())), new SearchResultValue(Lists.newArrayList((Iterable)results)));
    }
}

