/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.query.BaseQuery;
import io.druid.query.Query;
import io.druid.query.metadata.metadata.AllColumnIncluderator;
import io.druid.query.metadata.metadata.ColumnIncluderator;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.Map;

public class SegmentMetadataQuery
extends BaseQuery<SegmentAnalysis> {
    private final ColumnIncluderator toInclude;
    private final boolean merge;

    @JsonCreator
    public SegmentMetadataQuery(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="toInclude") ColumnIncluderator toInclude, @JsonProperty(value="merge") Boolean merge, @JsonProperty(value="context") Map<String, String> context) {
        super(dataSource, querySegmentSpec, context);
        this.toInclude = toInclude == null ? new AllColumnIncluderator() : toInclude;
        this.merge = merge == null ? false : merge;
    }

    @JsonProperty
    public ColumnIncluderator getToInclude() {
        return this.toInclude;
    }

    @JsonProperty
    public boolean isMerge() {
        return this.merge;
    }

    @Override
    public boolean hasFilters() {
        return false;
    }

    @Override
    public String getType() {
        return "segmentMetadata";
    }

    @Override
    public Query<SegmentAnalysis> withOverriddenContext(Map<String, String> contextOverride) {
        return new SegmentMetadataQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.toInclude, this.merge, this.computeOverridenContext(contextOverride));
    }

    @Override
    public Query<SegmentAnalysis> withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new SegmentMetadataQuery(this.getDataSource(), spec, this.toInclude, this.merge, this.getContext());
    }
}

