/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ColumnAnalysis {
    private static final String ERROR_PREFIX = "error:";
    private final String type;
    private final long size;
    private final Integer cardinality;
    private final String errorMessage;

    public static ColumnAnalysis error(String reason) {
        return new ColumnAnalysis("STRING", -1L, null, ERROR_PREFIX + reason);
    }

    @JsonCreator
    public ColumnAnalysis(@JsonProperty(value="type") String type, @JsonProperty(value="size") long size, @JsonProperty(value="cardinality") Integer cardinality, @JsonProperty(value="errorMessage") String errorMessage) {
        this.type = type;
        this.size = size;
        this.cardinality = cardinality;
        this.errorMessage = errorMessage;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty
    public Integer getCardinality() {
        return this.cardinality;
    }

    @JsonProperty
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isError() {
        return this.errorMessage != null && !this.errorMessage.isEmpty();
    }

    public ColumnAnalysis fold(ColumnAnalysis rhs) {
        if (rhs == null) {
            return this;
        }
        if (!this.type.equals(rhs.getType())) {
            return ColumnAnalysis.error("cannot_merge_diff_types");
        }
        Integer cardinality = this.getCardinality();
        Integer rhsCardinality = rhs.getCardinality();
        if (cardinality == null) {
            cardinality = rhsCardinality;
        } else if (rhsCardinality != null) {
            cardinality = Math.max(cardinality, rhsCardinality);
        }
        return new ColumnAnalysis(this.type, this.size + rhs.getSize(), cardinality, null);
    }

    public String toString() {
        return "ColumnAnalysis{type='" + this.type + '\'' + ", size=" + this.size + ", cardinality=" + this.cardinality + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }
}

