/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.metamx.common.guava.ExecutorExecutingSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.query.ConcatQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.metadata.SegmentAnalyzer;
import io.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import io.druid.query.metadata.metadata.ColumnAnalysis;
import io.druid.query.metadata.metadata.ColumnIncluderator;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import io.druid.segment.QueryableIndex;
import io.druid.segment.Segment;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class SegmentMetadataQueryRunnerFactory
implements QueryRunnerFactory<SegmentAnalysis, SegmentMetadataQuery> {
    private static final SegmentAnalyzer analyzer = new SegmentAnalyzer();
    private static final SegmentMetadataQueryQueryToolChest toolChest = new SegmentMetadataQueryQueryToolChest();

    @Override
    public QueryRunner<SegmentAnalysis> createRunner(final Segment segment) {
        return new QueryRunner<SegmentAnalysis>(){

            @Override
            public Sequence<SegmentAnalysis> run(Query<SegmentAnalysis> inQ) {
                SegmentMetadataQuery query = (SegmentMetadataQuery)inQ;
                QueryableIndex index = segment.asQueryableIndex();
                if (index == null) {
                    return Sequences.empty();
                }
                Map<String, ColumnAnalysis> analyzedColumns = analyzer.analyze(index);
                long totalSize = analyzedColumns.size() * index.getNumRows();
                TreeMap columns = Maps.newTreeMap();
                ColumnIncluderator includerator = query.getToInclude();
                for (Map.Entry<String, ColumnAnalysis> entry : analyzedColumns.entrySet()) {
                    String columnName = entry.getKey();
                    ColumnAnalysis column = entry.getValue();
                    if (!column.isError()) {
                        totalSize += column.getSize();
                    }
                    if (!includerator.include(columnName)) continue;
                    columns.put(columnName, column);
                }
                return Sequences.simple(Arrays.asList(new SegmentAnalysis(segment.getIdentifier(), Arrays.asList(segment.getDataInterval()), columns, totalSize)));
            }
        };
    }

    @Override
    public QueryRunner<SegmentAnalysis> mergeRunners(final ExecutorService queryExecutor, Iterable<QueryRunner<SegmentAnalysis>> queryRunners) {
        return new ConcatQueryRunner<SegmentAnalysis>(Sequences.map((Sequence)Sequences.simple(queryRunners), (Function)new Function<QueryRunner<SegmentAnalysis>, QueryRunner<SegmentAnalysis>>(){

            public QueryRunner<SegmentAnalysis> apply(final QueryRunner<SegmentAnalysis> input) {
                return new QueryRunner<SegmentAnalysis>(){

                    @Override
                    public Sequence<SegmentAnalysis> run(final Query<SegmentAnalysis> query) {
                        Future<Sequence<SegmentAnalysis>> future = queryExecutor.submit(new Callable<Sequence<SegmentAnalysis>>(){

                            @Override
                            public Sequence<SegmentAnalysis> call() throws Exception {
                                return new ExecutorExecutingSequence(input.run(query), queryExecutor);
                            }
                        });
                        try {
                            return future.get();
                        }
                        catch (InterruptedException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                        catch (ExecutionException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                };
            }
        }));
    }

    @Override
    public QueryToolChest<SegmentAnalysis, SegmentMetadataQuery> getToolchest() {
        return toolChest;
    }
}

