/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.metamx.common.logger.Logger;
import io.druid.query.metadata.metadata.ColumnAnalysis;
import io.druid.segment.QueryableIndex;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ComplexColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.util.Map;
import java.util.TreeMap;

public class SegmentAnalyzer {
    private static final Logger log = new Logger(SegmentAnalyzer.class);
    private static final int NUM_BYTES_IN_TIMESTAMP = 10;
    private static final int NUM_BYTES_IN_TEXT_FLOAT = 8;

    public Map<String, ColumnAnalysis> analyze(QueryableIndex index) {
        Preconditions.checkNotNull((Object)index, (Object)"Index cannot be null");
        TreeMap columns = Maps.newTreeMap();
        for (String columnName : index.getColumnNames()) {
            ColumnAnalysis analysis;
            Column column = index.getColumn(columnName);
            ColumnCapabilities capabilities = column.getCapabilities();
            ValueType type = capabilities.getType();
            switch (type) {
                case LONG: {
                    analysis = this.analyzeLongColumn(column);
                    break;
                }
                case FLOAT: {
                    analysis = this.analyzeFloatColumn(column);
                    break;
                }
                case STRING: {
                    analysis = this.analyzeStringColumn(column);
                    break;
                }
                case COMPLEX: {
                    analysis = this.analyzeComplexColumn(column);
                    break;
                }
                default: {
                    log.warn("Unknown column type[%s].", new Object[]{type});
                    analysis = ColumnAnalysis.error(String.format("unknown_type_%s", new Object[]{type}));
                }
            }
            columns.put(columnName, analysis);
        }
        columns.put("__time", this.lengthBasedAnalysis(index.getTimeColumn(), 10));
        return columns;
    }

    public ColumnAnalysis analyzeLongColumn(Column column) {
        return this.lengthBasedAnalysis(column, 8);
    }

    public ColumnAnalysis analyzeFloatColumn(Column column) {
        return this.lengthBasedAnalysis(column, 8);
    }

    private ColumnAnalysis lengthBasedAnalysis(Column column, int numBytes) {
        ColumnCapabilities capabilities = column.getCapabilities();
        if (capabilities.hasMultipleValues()) {
            return ColumnAnalysis.error("multi_value");
        }
        return new ColumnAnalysis(capabilities.getType().name(), column.getLength() * numBytes, null, null);
    }

    public ColumnAnalysis analyzeStringColumn(Column column) {
        ColumnCapabilities capabilities = column.getCapabilities();
        if (capabilities.hasBitmapIndexes()) {
            BitmapIndex bitmapIndex = column.getBitmapIndex();
            int cardinality = bitmapIndex.getCardinality();
            long size = 0L;
            for (int i = 0; i < cardinality; ++i) {
                String value = bitmapIndex.getValue(i);
                if (value == null) continue;
                size += (long)(value.getBytes(Charsets.UTF_8).length * bitmapIndex.getConciseSet(value).size());
            }
            return new ColumnAnalysis(capabilities.getType().name(), size, cardinality, null);
        }
        return ColumnAnalysis.error("string_no_bitmap");
    }

    public ColumnAnalysis analyzeComplexColumn(Column column) {
        ColumnCapabilities capabilities = column.getCapabilities();
        ComplexColumn complexColumn = column.getComplexColumn();
        String typeName = complexColumn.getTypeName();
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
        if (serde == null) {
            return ColumnAnalysis.error(String.format("unknown_complex_%s", typeName));
        }
        Function<Object, Long> inputSizeFn = serde.inputSizeFn();
        if (inputSizeFn == null) {
            return ColumnAnalysis.error("noSizeFn");
        }
        int length = column.getLength();
        long size = 0L;
        for (int i = 0; i < length; ++i) {
            size += ((Long)inputSizeFn.apply(complexColumn.getRowValue(i))).longValue();
        }
        return new ColumnAnalysis(capabilities.getType().name(), size, null, null);
    }
}

