/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.orderby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.data.input.Row;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.orderby.LimitSpec;
import io.druid.query.groupby.orderby.OrderByColumnSpec;
import io.druid.query.groupby.orderby.TopNSorter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class DefaultLimitSpec
implements LimitSpec {
    private final List<OrderByColumnSpec> columns;
    private final int limit;

    @JsonCreator
    public DefaultLimitSpec(@JsonProperty(value="columns") List<OrderByColumnSpec> columns, @JsonProperty(value="limit") Integer limit) {
        this.columns = columns == null ? ImmutableList.of() : columns;
        this.limit = limit == null ? Integer.MAX_VALUE : limit;
        Preconditions.checkArgument((this.limit > 0 ? 1 : 0) != 0, (String)"limit[%s] must be >0", (Object[])new Object[]{limit});
    }

    @JsonProperty
    public List<OrderByColumnSpec> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public int getLimit() {
        return this.limit;
    }

    @Override
    public Function<Sequence<Row>, Sequence<Row>> build(List<DimensionSpec> dimensions, List<AggregatorFactory> aggs, List<PostAggregator> postAggs) {
        if (this.columns.isEmpty()) {
            return new LimitingFn(this.limit);
        }
        Ordering<Row> ordering = this.makeComparator(dimensions, aggs, postAggs);
        if (this.limit == Integer.MAX_VALUE) {
            return new SortingFn(ordering);
        }
        return new TopNFunction(ordering, this.limit);
    }

    private Ordering<Row> makeComparator(List<DimensionSpec> dimensions, List<AggregatorFactory> aggs, List<PostAggregator> postAggs) {
        String column;
        Ordering<Row> ordering = new Ordering<Row>(){

            public int compare(Row left, Row right) {
                return Longs.compare((long)left.getTimestampFromEpoch(), (long)right.getTimestampFromEpoch());
            }
        };
        TreeMap possibleOrderings = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (DimensionSpec spec : dimensions) {
            String dimension = spec.getOutputName();
            possibleOrderings.put(dimension, this.dimensionOrdering(dimension));
        }
        for (AggregatorFactory agg : aggs) {
            column = agg.getName();
            possibleOrderings.put(column, this.metricOrdering(column, agg.getComparator()));
        }
        for (PostAggregator postAgg : postAggs) {
            column = postAgg.getName();
            possibleOrderings.put(column, this.metricOrdering(column, postAgg.getComparator()));
        }
        for (OrderByColumnSpec columnSpec : this.columns) {
            Ordering nextOrdering = (Ordering)possibleOrderings.get(columnSpec.getDimension());
            if (nextOrdering == null) {
                throw new ISE("Unknown column in order clause[%s]", new Object[]{columnSpec});
            }
            switch (columnSpec.getDirection()) {
                case DESCENDING: {
                    nextOrdering = nextOrdering.reverse();
                }
            }
            ordering = ordering.compound((Comparator)nextOrdering);
        }
        return ordering;
    }

    private Ordering<Row> metricOrdering(final String column, final Comparator comparator) {
        return new Ordering<Row>(){

            public int compare(Row left, Row right) {
                return comparator.compare(left.getRaw(column), right.getRaw(column));
            }
        };
    }

    private Ordering<Row> dimensionOrdering(final String dimension) {
        return Ordering.natural().nullsFirst().onResultOf((Function)new Function<Row, String>(){

            public String apply(Row input) {
                List dimList = input.getDimension(dimension);
                return dimList.isEmpty() ? null : (String)dimList.get(0);
            }
        });
    }

    public String toString() {
        return "DefaultLimitSpec{columns='" + this.columns + '\'' + ", limit=" + this.limit + '}';
    }

    private static class TopNFunction
    implements Function<Sequence<Row>, Sequence<Row>> {
        private final TopNSorter<Row> sorter;
        private final int limit;

        public TopNFunction(Ordering<Row> ordering, int limit) {
            this.limit = limit;
            this.sorter = new TopNSorter<Row>(ordering);
        }

        public Sequence<Row> apply(@Nullable Sequence<Row> input) {
            ArrayList materializedList = (ArrayList)Sequences.toList(input, (List)Lists.newArrayList());
            return Sequences.simple(this.sorter.toTopN(materializedList, this.limit));
        }
    }

    private static class SortingFn
    implements Function<Sequence<Row>, Sequence<Row>> {
        private final Ordering<Row> ordering;

        public SortingFn(Ordering<Row> ordering) {
            this.ordering = ordering;
        }

        public Sequence<Row> apply(@Nullable Sequence<Row> input) {
            return Sequences.sort(input, this.ordering);
        }
    }

    private static class LimitingFn
    implements Function<Sequence<Row>, Sequence<Row>> {
        private int limit;

        public LimitingFn(int limit) {
            this.limit = limit;
        }

        public Sequence<Row> apply(@Nullable Sequence<Row> input) {
            return Sequences.limit(input, (int)this.limit);
        }
    }
}

