/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.data.input.Row;
import io.druid.query.groupby.having.HavingSpec;

public class LessThanHavingSpec
implements HavingSpec {
    private String aggregationName;
    private Number value;

    public LessThanHavingSpec(@JsonProperty(value="aggregation") String aggName, @JsonProperty(value="value") Number value) {
        this.aggregationName = aggName;
        this.value = value;
    }

    @JsonProperty(value="aggregation")
    public String getAggregationName() {
        return this.aggregationName;
    }

    @JsonProperty(value="value")
    public Number getValue() {
        return this.value;
    }

    @Override
    public boolean eval(Row row) {
        float metricValue = row.getFloatMetric(this.aggregationName);
        return Float.compare(metricValue, this.value.floatValue()) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LessThanHavingSpec that = (LessThanHavingSpec)o;
        if (this.value != null && that.value != null) {
            return Double.compare(this.value.doubleValue(), that.value.doubleValue()) == 0;
        }
        return this.value == null && that.value == null;
    }

    public int hashCode() {
        int result = this.aggregationName != null ? this.aggregationName.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LessThanHavingSpec");
        sb.append("{aggregationName='").append(this.aggregationName).append('\'');
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }
}

