/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.data.input.Row;
import io.druid.query.groupby.having.HavingSpec;

public class EqualToHavingSpec
implements HavingSpec {
    private String aggregationName;
    private Number value;

    @JsonCreator
    public EqualToHavingSpec(@JsonProperty(value="aggregation") String aggName, @JsonProperty(value="value") Number value) {
        this.aggregationName = aggName;
        this.value = value;
    }

    @JsonProperty(value="value")
    public Number getValue() {
        return this.value;
    }

    @JsonProperty(value="aggregation")
    public String getAggregationName() {
        return this.aggregationName;
    }

    @Override
    public boolean eval(Row row) {
        float metricValue = row.getFloatMetric(this.aggregationName);
        return Float.compare(this.value.floatValue(), metricValue) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqualToHavingSpec that = (EqualToHavingSpec)o;
        if (this.aggregationName != null ? !this.aggregationName.equals(that.aggregationName) : that.aggregationName != null) {
            return false;
        }
        if (this.value != null && that.value != null) {
            return Double.compare(this.value.doubleValue(), that.value.doubleValue()) == 0;
        }
        return this.value == null && that.value == null;
    }

    public int hashCode() {
        int result = this.aggregationName != null ? this.aggregationName.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EqualToHavingSpec");
        sb.append("{aggregationName='").append(this.aggregationName).append('\'');
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }
}

