/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.druid.data.input.Row;
import io.druid.query.groupby.having.HavingSpec;
import java.util.List;

public class AndHavingSpec
implements HavingSpec {
    private List<HavingSpec> havingSpecs;

    @JsonCreator
    public AndHavingSpec(@JsonProperty(value="havingSpecs") List<HavingSpec> havingSpecs) {
        this.havingSpecs = havingSpecs == null ? ImmutableList.of() : havingSpecs;
    }

    @JsonProperty(value="havingSpecs")
    public List<HavingSpec> getHavingSpecs() {
        return this.havingSpecs;
    }

    @Override
    public boolean eval(Row row) {
        for (HavingSpec havingSpec : this.havingSpecs) {
            if (havingSpec.eval(row)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndHavingSpec that = (AndHavingSpec)o;
        return !(this.havingSpecs != null ? !this.havingSpecs.equals(that.havingSpecs) : that.havingSpecs != null);
    }

    public int hashCode() {
        return this.havingSpecs != null ? this.havingSpecs.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AndHavingSpec");
        sb.append("{havingSpecs=").append(this.havingSpecs);
        sb.append('}');
        return sb.toString();
    }
}

