/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.guava.ExecutorExecutingSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.data.input.Row;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.ConcatQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class GroupByQueryRunnerFactory
implements QueryRunnerFactory<Row, GroupByQuery> {
    private final GroupByQueryEngine engine;
    private final Supplier<GroupByQueryConfig> config;
    private final GroupByQueryQueryToolChest toolChest;

    @Inject
    public GroupByQueryRunnerFactory(GroupByQueryEngine engine, Supplier<GroupByQueryConfig> config, GroupByQueryQueryToolChest toolChest) {
        this.engine = engine;
        this.config = config;
        this.toolChest = toolChest;
    }

    @Override
    public QueryRunner<Row> createRunner(Segment segment) {
        return new GroupByQueryRunner(segment, this.engine);
    }

    @Override
    public QueryRunner<Row> mergeRunners(final ExecutorService queryExecutor, Iterable<QueryRunner<Row>> queryRunners) {
        if (((GroupByQueryConfig)this.config.get()).isSingleThreaded()) {
            return new ConcatQueryRunner<Row>(Sequences.map((Sequence)Sequences.simple(queryRunners), (Function)new Function<QueryRunner<Row>, QueryRunner<Row>>(){

                public QueryRunner<Row> apply(final QueryRunner<Row> input) {
                    return new QueryRunner<Row>(){

                        @Override
                        public Sequence<Row> run(final Query<Row> query) {
                            Future<Sequence<Row>> future = queryExecutor.submit(new Callable<Sequence<Row>>(){

                                @Override
                                public Sequence<Row> call() throws Exception {
                                    return new ExecutorExecutingSequence(input.run(query), queryExecutor);
                                }
                            });
                            try {
                                return future.get();
                            }
                            catch (InterruptedException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                            catch (ExecutionException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                    };
                }
            }));
        }
        return new ChainedExecutionQueryRunner<Row>(queryExecutor, new RowOrdering(), queryRunners);
    }

    @Override
    public QueryToolChest<Row, GroupByQuery> getToolchest() {
        return this.toolChest;
    }

    private static class RowOrdering
    extends Ordering<Row> {
        private RowOrdering() {
        }

        public int compare(Row left, Row right) {
            return Longs.compare((long)left.getTimestampFromEpoch(), (long)right.getTimestampFromEpoch());
        }
    }

    private static class GroupByQueryRunner
    implements QueryRunner<Row> {
        private final StorageAdapter adapter;
        private final GroupByQueryEngine engine;

        public GroupByQueryRunner(Segment segment, GroupByQueryEngine engine) {
            this.adapter = segment.asStorageAdapter();
            this.engine = engine;
        }

        @Override
        public Sequence<Row> run(Query<Row> input) {
            if (!(input instanceof GroupByQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), GroupByQuery.class});
            }
            return this.engine.process((GroupByQuery)input, this.adapter);
        }
    }
}

