/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.ConcatSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.data.input.Rows;
import io.druid.granularity.QueryGranularity;
import io.druid.query.IntervalChunkingQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.segment.incremental.IncrementalIndex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.Interval;
import org.joda.time.Minutes;
import org.joda.time.ReadableInterval;

public class GroupByQueryQueryToolChest
extends QueryToolChest<Row, GroupByQuery> {
    private static final TypeReference<Row> TYPE_REFERENCE = new TypeReference<Row>(){};
    private static final String GROUP_BY_MERGE_KEY = "groupByMerge";
    private static final Map<String, String> NO_MERGE_CONTEXT = ImmutableMap.of((Object)"groupByMerge", (Object)"false");
    private final Supplier<GroupByQueryConfig> configSupplier;

    @Inject
    public GroupByQueryQueryToolChest(Supplier<GroupByQueryConfig> configSupplier) {
        this.configSupplier = configSupplier;
    }

    @Override
    public QueryRunner<Row> mergeResults(final QueryRunner<Row> runner) {
        return new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(Query<Row> input) {
                if (Boolean.valueOf(input.getContextValue(GroupByQueryQueryToolChest.GROUP_BY_MERGE_KEY, "true")).booleanValue()) {
                    return GroupByQueryQueryToolChest.this.mergeGroupByResults((GroupByQuery)((GroupByQuery)input).withOverriddenContext(NO_MERGE_CONTEXT), runner);
                }
                return runner.run(input);
            }
        };
    }

    private Sequence<Row> mergeGroupByResults(GroupByQuery query, QueryRunner<Row> runner) {
        final GroupByQueryConfig config = (GroupByQueryConfig)this.configSupplier.get();
        final QueryGranularity gran = query.getGranularity();
        long timeStart = query.getIntervals().get(0).getStartMillis();
        long granTimeStart = gran.iterable(timeStart, timeStart + 1L).iterator().next();
        List aggs = Lists.transform(query.getAggregatorSpecs(), (Function)new Function<AggregatorFactory, AggregatorFactory>(){

            public AggregatorFactory apply(@Nullable AggregatorFactory input) {
                return input.getCombiningFactory();
            }
        });
        final List dimensions = Lists.transform(query.getDimensions(), (Function)new Function<DimensionSpec, String>(){

            public String apply(@Nullable DimensionSpec input) {
                return input.getOutputName();
            }
        });
        IncrementalIndex index = (IncrementalIndex)runner.run(query).accumulate((Object)new IncrementalIndex(granTimeStart, gran, aggs.toArray(new AggregatorFactory[aggs.size()])), (Accumulator)new Accumulator<IncrementalIndex, Row>(){

            public IncrementalIndex accumulate(IncrementalIndex accumulated, Row in) {
                if (accumulated.add(Rows.toCaseInsensitiveInputRow((Row)in, (List)dimensions)) > config.getMaxResults()) {
                    throw new ISE("Computation exceeds maxRows limit[%s]", new Object[]{config.getMaxResults()});
                }
                return accumulated;
            }
        });
        Sequence retVal = Sequences.map((Sequence)Sequences.simple(index.iterableWithPostAggregations(query.getPostAggregatorSpecs())), (Function)new Function<Row, Row>(){

            public Row apply(Row input) {
                MapBasedRow row = (MapBasedRow)input;
                return new MapBasedRow(gran.toDateTime(row.getTimestampFromEpoch()), row.getEvent());
            }
        });
        return query.applyLimit((Sequence<Row>)retVal);
    }

    @Override
    public Sequence<Row> mergeSequences(Sequence<Sequence<Row>> seqOfSequences) {
        return new ConcatSequence(seqOfSequences);
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(GroupByQuery query) {
        int numMinutes = 0;
        for (Interval interval : query.getIntervals()) {
            numMinutes += Minutes.minutesIn((ReadableInterval)interval).getMinutes();
        }
        return new ServiceMetricEvent.Builder().setUser2(query.getDataSource()).setUser3(String.format("%,d dims", query.getDimensions().size())).setUser4("groupBy").setUser5(Joiner.on((String)",").join(query.getIntervals())).setUser6(String.valueOf(query.hasFilters())).setUser7(String.format("%,d aggs", query.getAggregatorSpecs().size())).setUser9(Minutes.minutes((int)numMinutes).toString());
    }

    @Override
    public Function<Row, Row> makeMetricManipulatorFn(final GroupByQuery query, final MetricManipulationFn fn) {
        return new Function<Row, Row>(){

            public Row apply(Row input) {
                if (input instanceof MapBasedRow) {
                    MapBasedRow inputRow = (MapBasedRow)input;
                    HashMap values = Maps.newHashMap((Map)((MapBasedRow)input).getEvent());
                    for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                        values.put(agg.getName(), fn.manipulate(agg, inputRow.getEvent().get(agg.getName())));
                    }
                    return new MapBasedRow(inputRow.getTimestamp(), (Map)values);
                }
                return input;
            }
        };
    }

    @Override
    public TypeReference<Row> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public QueryRunner<Row> preMergeQueryDecoration(QueryRunner<Row> runner) {
        return new IntervalChunkingQueryRunner<Row>(runner, ((GroupByQueryConfig)this.configSupplier.get()).getChunkPeriod());
    }
}

