/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.data.input.Row;
import io.druid.granularity.QueryGranularity;
import io.druid.query.BaseQuery;
import io.druid.query.Queries;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.groupby.having.HavingSpec;
import io.druid.query.groupby.orderby.DefaultLimitSpec;
import io.druid.query.groupby.orderby.LimitSpec;
import io.druid.query.groupby.orderby.NoopLimitSpec;
import io.druid.query.groupby.orderby.OrderByColumnSpec;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class GroupByQuery
extends BaseQuery<Row> {
    private final LimitSpec limitSpec;
    private final HavingSpec havingSpec;
    private final DimFilter dimFilter;
    private final QueryGranularity granularity;
    private final List<DimensionSpec> dimensions;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;
    private final Function<Sequence<Row>, Sequence<Row>> orderByLimitFn;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public GroupByQuery(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") QueryGranularity granularity, @JsonProperty(value="dimensions") List<DimensionSpec> dimensions, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="having") HavingSpec havingSpec, @JsonProperty(value="limitSpec") LimitSpec limitSpec, @JsonProperty(value="orderBy") LimitSpec orderBySpec, @JsonProperty(value="context") Map<String, String> context) {
        super(dataSource, querySegmentSpec, context);
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.dimensions = dimensions == null ? ImmutableList.of() : dimensions;
        this.aggregatorSpecs = aggregatorSpecs;
        this.postAggregatorSpecs = postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs;
        this.havingSpec = havingSpec;
        this.limitSpec = limitSpec == null ? (orderBySpec == null ? new NoopLimitSpec() : orderBySpec) : limitSpec;
        Preconditions.checkNotNull((Object)this.granularity, (Object)"Must specify a granularity");
        Preconditions.checkNotNull(this.aggregatorSpecs, (Object)"Must specify at least one aggregator");
        Queries.verifyAggregations(this.aggregatorSpecs, this.postAggregatorSpecs);
        Function postProcFn = this.limitSpec.build(this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs);
        if (havingSpec != null) {
            postProcFn = Functions.compose((Function)new Function<Sequence<Row>, Sequence<Row>>(){

                public Sequence<Row> apply(@Nullable Sequence<Row> input) {
                    return Sequences.filter(input, (Predicate)new Predicate<Row>(){

                        public boolean apply(@Nullable Row input) {
                            return GroupByQuery.this.havingSpec.eval(input);
                        }
                    });
                }
            }, postProcFn);
        }
        this.orderByLimitFn = postProcFn;
    }

    private GroupByQuery(String dataSource, QuerySegmentSpec querySegmentSpec, DimFilter dimFilter, QueryGranularity granularity, List<DimensionSpec> dimensions, List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs, HavingSpec havingSpec, LimitSpec orderBySpec, Function<Sequence<Row>, Sequence<Row>> orderByLimitFn, Map<String, String> context) {
        super(dataSource, querySegmentSpec, context);
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.dimensions = dimensions;
        this.aggregatorSpecs = aggregatorSpecs;
        this.postAggregatorSpecs = postAggregatorSpecs;
        this.havingSpec = havingSpec;
        this.limitSpec = orderBySpec;
        this.orderByLimitFn = orderByLimitFn;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty
    public List<DimensionSpec> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="postAggregations")
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    @JsonProperty(value="having")
    public HavingSpec getHavingSpec() {
        return this.havingSpec;
    }

    @JsonProperty
    public LimitSpec getOrderBy() {
        return this.limitSpec;
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public String getType() {
        return "groupBy";
    }

    public Sequence<Row> applyLimit(Sequence<Row> results) {
        return (Sequence)this.orderByLimitFn.apply(results);
    }

    public GroupByQuery withOverriddenContext(Map<String, String> contextOverride) {
        return new GroupByQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs, this.havingSpec, this.limitSpec, this.orderByLimitFn, this.computeOverridenContext(contextOverride));
    }

    public GroupByQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new GroupByQuery(this.getDataSource(), spec, this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs, this.havingSpec, this.limitSpec, this.orderByLimitFn, this.getContext());
    }

    public String toString() {
        return "GroupByQuery{limitSpec=" + this.limitSpec + ", dimFilter=" + this.dimFilter + ", granularity=" + this.granularity + ", dimensions=" + this.dimensions + ", aggregatorSpecs=" + this.aggregatorSpecs + ", postAggregatorSpecs=" + this.postAggregatorSpecs + ", orderByLimitFn=" + this.orderByLimitFn + '}';
    }

    public static class Builder {
        private String dataSource;
        private QuerySegmentSpec querySegmentSpec;
        private DimFilter dimFilter;
        private QueryGranularity granularity;
        private List<DimensionSpec> dimensions;
        private List<AggregatorFactory> aggregatorSpecs;
        private List<PostAggregator> postAggregatorSpecs;
        private HavingSpec havingSpec;
        private Map<String, String> context;
        private LimitSpec limitSpec = null;
        private List<OrderByColumnSpec> orderByColumnSpecs = Lists.newArrayList();
        private int limit = Integer.MAX_VALUE;

        private Builder() {
        }

        private Builder(Builder builder) {
            this.dataSource = builder.dataSource;
            this.querySegmentSpec = builder.querySegmentSpec;
            this.limitSpec = builder.limitSpec;
            this.dimFilter = builder.dimFilter;
            this.granularity = builder.granularity;
            this.dimensions = builder.dimensions;
            this.aggregatorSpecs = builder.aggregatorSpecs;
            this.postAggregatorSpecs = builder.postAggregatorSpecs;
            this.havingSpec = builder.havingSpec;
            this.limit = builder.limit;
            this.context = builder.context;
        }

        public Builder setDataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder setInterval(Object interval) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec(interval));
        }

        public Builder limit(int limit) {
            this.ensureExplicitLimitNotSet();
            this.limit = limit;
            return this;
        }

        public Builder addOrderByColumn(String dimension) {
            return this.addOrderByColumn(dimension, (OrderByColumnSpec.Direction)null);
        }

        public Builder addOrderByColumn(String dimension, String direction) {
            return this.addOrderByColumn(dimension, OrderByColumnSpec.determineDirection(direction));
        }

        public Builder addOrderByColumn(String dimension, OrderByColumnSpec.Direction direction) {
            return this.addOrderByColumn(new OrderByColumnSpec(dimension, direction));
        }

        public Builder addOrderByColumn(OrderByColumnSpec columnSpec) {
            this.ensureExplicitLimitNotSet();
            this.orderByColumnSpecs.add(columnSpec);
            return this;
        }

        public Builder setLimitSpec(LimitSpec limitSpec) {
            this.ensureFluentLimitsNotSet();
            this.limitSpec = limitSpec;
            return this;
        }

        private void ensureExplicitLimitNotSet() {
            if (this.limitSpec != null) {
                throw new ISE("Ambiguous build, limitSpec[%s] already set", new Object[]{this.limitSpec});
            }
        }

        private void ensureFluentLimitsNotSet() {
            if (this.limit != Integer.MAX_VALUE || !this.orderByColumnSpecs.isEmpty()) {
                throw new ISE("Ambiguous build, limit[%s] or columnSpecs[%s] already set.", new Object[]{this.limit, this.orderByColumnSpecs});
            }
        }

        public Builder setQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
            this.querySegmentSpec = querySegmentSpec;
            return this;
        }

        public Builder setDimFilter(DimFilter dimFilter) {
            this.dimFilter = dimFilter;
            return this;
        }

        public Builder setGranularity(QueryGranularity granularity) {
            this.granularity = granularity;
            return this;
        }

        public Builder addDimension(String column) {
            return this.addDimension(column, column);
        }

        public Builder addDimension(String column, String outputName) {
            return this.addDimension(new DefaultDimensionSpec(column, outputName));
        }

        public Builder addDimension(DimensionSpec dimension) {
            if (this.dimensions == null) {
                this.dimensions = Lists.newArrayList();
            }
            this.dimensions.add(dimension);
            return this;
        }

        public Builder setDimensions(List<DimensionSpec> dimensions) {
            this.dimensions = Lists.newArrayList(dimensions);
            return this;
        }

        public Builder addAggregator(AggregatorFactory aggregator) {
            if (this.aggregatorSpecs == null) {
                this.aggregatorSpecs = Lists.newArrayList();
            }
            this.aggregatorSpecs.add(aggregator);
            return this;
        }

        public Builder setAggregatorSpecs(List<AggregatorFactory> aggregatorSpecs) {
            this.aggregatorSpecs = Lists.newArrayList(aggregatorSpecs);
            return this;
        }

        public Builder addPostAggregator(PostAggregator postAgg) {
            if (this.postAggregatorSpecs == null) {
                this.postAggregatorSpecs = Lists.newArrayList();
            }
            this.postAggregatorSpecs.add(postAgg);
            return this;
        }

        public Builder setPostAggregatorSpecs(List<PostAggregator> postAggregatorSpecs) {
            this.postAggregatorSpecs = Lists.newArrayList(postAggregatorSpecs);
            return this;
        }

        public Builder setContext(Map<String, String> context) {
            this.context = context;
            return this;
        }

        public Builder setHavingSpec(HavingSpec havingSpec) {
            this.havingSpec = havingSpec;
            return this;
        }

        public Builder setLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public GroupByQuery build() {
            LimitSpec theLimitSpec = this.limitSpec == null ? new DefaultLimitSpec(this.orderByColumnSpecs, this.limit) : this.limitSpec;
            return new GroupByQuery(this.dataSource, this.querySegmentSpec, this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs, this.havingSpec, null, theLimitSpec, this.context);
        }
    }
}

