/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.collections.spatial.search.Bound;
import io.druid.query.filter.DimFilter;
import java.nio.ByteBuffer;

public class SpatialDimFilter
implements DimFilter {
    private final String dimension;
    private final Bound bound;

    @JsonCreator
    public SpatialDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="bound") Bound bound) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkArgument((bound != null ? 1 : 0) != 0, (Object)"bound must not be null");
        this.dimension = dimension;
        this.bound = bound;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimBytes = this.dimension.getBytes();
        byte[] boundBytes = this.bound.getCacheKey();
        return ByteBuffer.allocate(1 + dimBytes.length + boundBytes.length).put((byte)8).put(dimBytes).put(boundBytes).array();
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public Bound getBound() {
        return this.bound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpatialDimFilter that = (SpatialDimFilter)o;
        if (this.bound != null ? !this.bound.equals(that.bound) : that.bound != null) {
            return false;
        }
        return !(this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.bound != null ? this.bound.hashCode() : 0);
        return result;
    }
}

