/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.DimFilterCacheHelper;
import java.util.Collections;
import java.util.List;

public class OrDimFilter
implements DimFilter {
    private static final Joiner OR_JOINER = Joiner.on((String)" || ");
    private final List<DimFilter> fields;

    @JsonCreator
    public OrDimFilter(@JsonProperty(value="fields") List<DimFilter> fields) {
        fields.removeAll(Collections.singletonList(null));
        Preconditions.checkArgument((fields.size() > 0 ? 1 : 0) != 0, (Object)"OR operator requires at least one field");
        this.fields = fields;
    }

    @JsonProperty
    public List<DimFilter> getFields() {
        return this.fields;
    }

    @Override
    public byte[] getCacheKey() {
        return DimFilterCacheHelper.computeCacheKey((byte)2, this.fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrDimFilter that = (OrDimFilter)o;
        return !(this.fields != null ? !this.fields.equals(that.fields) : that.fields != null);
    }

    public int hashCode() {
        return this.fields != null ? this.fields.hashCode() : 0;
    }

    public String toString() {
        return String.format("(%s)", OR_JOINER.join(this.fields));
    }
}

