/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.druid.query.filter.DimFilter;
import java.nio.ByteBuffer;

public class JavaScriptDimFilter
implements DimFilter {
    private final String dimension;
    private final String function;

    @JsonCreator
    public JavaScriptDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="function") String function) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkArgument((function != null ? 1 : 0) != 0, (Object)"function must not be null");
        this.dimension = dimension;
        this.function = function;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = this.dimension.getBytes(Charsets.UTF_8);
        byte[] functionBytes = this.function.getBytes(Charsets.UTF_8);
        return ByteBuffer.allocate(1 + dimensionBytes.length + functionBytes.length).put((byte)7).put(dimensionBytes).put(functionBytes).array();
    }
}

