/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.filter.DimFilter;
import java.nio.ByteBuffer;

public class ExtractionDimFilter
implements DimFilter {
    private final String dimension;
    private final String value;
    private final DimExtractionFn dimExtractionFn;

    @JsonCreator
    public ExtractionDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="value") String value, @JsonProperty(value="dimExtractionFn") DimExtractionFn dimExtractionFn) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value must not be null");
        Preconditions.checkArgument((dimExtractionFn != null ? 1 : 0) != 0, (Object)"extraction function must not be null");
        this.dimension = dimension;
        this.value = value;
        this.dimExtractionFn = dimExtractionFn;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public DimExtractionFn getDimExtractionFn() {
        return this.dimExtractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = this.dimension.getBytes();
        byte[] valueBytes = this.value.getBytes();
        return ByteBuffer.allocate(1 + dimensionBytes.length + valueBytes.length).put((byte)4).put(dimensionBytes).put(valueBytes).array();
    }

    public String toString() {
        return String.format("%s(%s) = %s", this.dimExtractionFn, this.dimension, this.value);
    }
}

