/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.DimExtractionFn;
import java.nio.ByteBuffer;

public class ExtractionDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 1;
    private final String dimension;
    private final DimExtractionFn dimExtractionFn;
    private final String outputName;

    @JsonCreator
    public ExtractionDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") String outputName, @JsonProperty(value="dimExtractionFn") DimExtractionFn dimExtractionFn) {
        this.dimension = dimension;
        this.dimExtractionFn = dimExtractionFn;
        this.outputName = outputName == null ? dimension : outputName;
    }

    @Override
    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    @JsonProperty
    public DimExtractionFn getDimExtractionFn() {
        return this.dimExtractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = this.dimension.getBytes();
        byte[] dimExtractionFnBytes = this.dimExtractionFn.getCacheKey();
        return ByteBuffer.allocate(1 + dimensionBytes.length + dimExtractionFnBytes.length).put((byte)1).put(dimensionBytes).put(dimExtractionFnBytes).array();
    }

    public String toString() {
        return "ExtractionDimensionSpec{dimension='" + this.dimension + '\'' + ", dimExtractionFn=" + this.dimExtractionFn + ", outputName='" + this.outputName + '\'' + '}';
    }
}

